﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AsystenZakupówWPF.Model
{
    public class SumowanieKwot
    {
        public decimal Limit { get; private set; }
        public decimal Suma { get; private set; }

        public SumowanieKwot(decimal limit, decimal suma = 0)
        {
            Limit = limit;
            Suma = suma;
        }

        public void Dodaj(decimal kwota)
        {
            if (!CzyKwotaJestPoprawna(kwota))
                throw new ArgumentException("Kwota zbyt duża lub nie dodatnia");
            Suma += kwota;
        }

        public bool CzyKwotaJestPoprawna(decimal kwota)
        {
            bool czyKwotaJestDodatnia = kwota > 0;
            bool czyKwotaPrzekroczyLimit = Suma + kwota > Limit;
            return czyKwotaJestDodatnia && !czyKwotaPrzekroczyLimit;
        }
    }
}
