﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Interactivity;

namespace KoloryWPF
{
    public class ZamknięcieOknaPoNaciśnięciuKlawisza : Behavior<Window>
    {
        public Key Klawisz { get; set; }

        protected override void OnAttached()
        {
            Window window = this.AssociatedObject;
            if(window != null) window.PreviewKeyDown += Window_PreviewKeyDown;
        }

        private void Window_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            Window window = (Window)sender;
            if (e.Key == Klawisz) window.Close();
        }
    }

    public class PrzyciskZamykającyOkno : Behavior<Window>
    {
        public static readonly DependencyProperty PrzyciskProperty =
            DependencyProperty.Register(
                "Przycisk",
                typeof(Button),
                typeof(PrzyciskZamykającyOkno),
                new PropertyMetadata(null, PrzyciskZmieniony));

        public Button Przycisk
        {
            get { return (Button)GetValue(PrzyciskProperty); }
            set { SetValue(PrzyciskProperty, value); }
        }

        private static void PrzyciskZmieniony(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            Window window = (d as PrzyciskZamykającyOkno).AssociatedObject;
            RoutedEventHandler button_click = 
                (object sender, RoutedEventArgs _e) =>
                {
                    ICommand polecenie = (d as PrzyciskZamykającyOkno).Polecenie;
                    object parametrPolecenia = (d as PrzyciskZamykającyOkno).ParametrPolecenia;
                    if (polecenie != null) polecenie.Execute(parametrPolecenia);
                    window.Close();
                };
            if (e.OldValue != null) ((Button)e.OldValue).Click -= button_click;
            if (e.NewValue != null) ((Button)e.NewValue).Click += button_click;
        }

        public static readonly DependencyProperty PolecenieProperty =
            DependencyProperty.Register(
                "Polecenie",
                typeof(ICommand),
                typeof(PrzyciskZamykającyOkno));

        public ICommand Polecenie
        {
            get { return (ICommand)GetValue(PolecenieProperty); }
            set { SetValue(PolecenieProperty, value); }
        }

        public static readonly DependencyProperty ParametrPoleceniaProperty =
            DependencyProperty.Register(
                "ParametrPolecenia",
                typeof(object),
                typeof(PrzyciskZamykającyOkno));

        public object ParametrPolecenia
        {
            get { return (object)GetValue(ParametrPoleceniaProperty); }
            set { SetValue(ParametrPoleceniaProperty, value); }
        }
    }

    public static class KlawiszWyłączBehavior
    {
        public static Key GetKlawisz(DependencyObject d)
        {
            return (Key)d.GetValue(KlawiszProperty);
        }

        public static void SetKlawisz(DependencyObject d, Key value)
        {
            d.SetValue(KlawiszProperty, value);
        }

        public static readonly DependencyProperty KlawiszProperty =
            DependencyProperty.RegisterAttached(
                "Klawisz",
                typeof(Key),
                typeof(KlawiszWyłączBehavior),
                new PropertyMetadata(Key.None, KlawiszZmieniony));

        public static void KlawiszZmieniony(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            Key klawisz = (Key)e.NewValue;
            if(d is Window)
            {
                (d as Window).PreviewKeyDown +=
                    (object sender, KeyEventArgs _e) =>
                    {
                        if (_e.Key == klawisz) (sender as Window).Close();
                    };
            }
            else
            {
                (d as UIElement).PreviewKeyDown +=
                    (object sender, KeyEventArgs _e) =>
                    {
                        if (_e.Key == klawisz) (sender as UIElement).IsEnabled = false;
                    };
            }
        }
    }
}
