﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Windows.Media;
using KoloryWPF.Model;
using System.ComponentModel;
using System.Windows.Input;

namespace KoloryWPF.ModelWidoku
{
    public class EdycjaKoloru : INotifyPropertyChanged
    {
        private Kolor kolor = Ustawienia.Czytaj();

        public byte R
        {
            get
            {
                return kolor.R;
            }
            set
            {
                kolor.R = value;
                //OnPropertyChanged("R", "Color");
                OnPropertyChanged("R");
            }
        }

        public byte G
        {
            get
            {
                return kolor.G;
            }
            set
            {
                kolor.G = value;
                //OnPropertyChanged("G", "Color");
                OnPropertyChanged("G");
            }
        }

        public byte B
        {
            get
            {
                return kolor.B;
            }
            set
            {
                kolor.B = value;
                //OnPropertyChanged("B", "Color");
                OnPropertyChanged("B");
            }
        }

        /*
        public Color Color
        {
            get
            {
                return kolor.ToColor();
            }
        }
        */

        /*
        public void Zapisz()
        {
            Ustawienia.Zapisz(kolor);
        }
        */

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if (PropertyChanged != null)
            {
                foreach (string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
            }
        }

        private ICommand resetujCommand;

        /*
        public ICommand Resetuj
        {
            get
            {
                if (resetujCommand == null) resetujCommand = new ResetujCommand(this);
                return resetujCommand;
            }
        }
        */

        public ICommand Resetuj
        {
            get
            {
                if(resetujCommand==null)
                {                    
                    resetujCommand = new RelayCommand(
                        argument =>
                        {
                            R = 0;
                            G = 0;
                            B = 0;
                        },
                        argument => (R != 0) || (G != 0) || (B != 0)
                        );
                }
                return resetujCommand;
            }
        }

        private ICommand zapiszCommand;

        public ICommand Zapisz
        {
            get
            {
                if (zapiszCommand == null)
                    zapiszCommand = new RelayCommand(
                        argument =>
                        {
                            Ustawienia.Zapisz(kolor);
                        });
                return zapiszCommand;
            }
        }

        //bardzo brzydkie, niezgodne z MVVM polecenie!!!!!!!!
        public ICommand ZamknijOkno
        {
            get
            {
                return new RelayCommand(
                    argument => { (argument as System.Windows.Window).Close(); });
            }
        }
    }

    /*
    class ResetujCommand : ICommand
    {
        private EdycjaKoloru modelWidoku;

        public ResetujCommand(EdycjaKoloru modelWidoku)
        {
            this.modelWidoku = modelWidoku;
        }

        public event EventHandler CanExecuteChanged
        {
            add
            {
                CommandManager.RequerySuggested += value;
            }
            remove
            {
                CommandManager.RequerySuggested -= value;
            }
        }

        public bool CanExecute(object parametr)
        {
            return !((modelWidoku.R == 0) && (modelWidoku.G == 0) && (modelWidoku.B == 0));
        }

        public void Execute(object parametr)
        {            
            if(modelWidoku != null)
            {
                modelWidoku.R = 0;
                modelWidoku.G = 0;
                modelWidoku.B = 0;
            }
        }
    }
    */

    static class Rozszerzenia
    {
        public static Color ToColor(this Kolor kolor)
        {
            return Color.FromRgb(kolor.R, kolor.G, kolor.B);
        }
    }
}
