﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Windows.Media;
using KoloryWPF.Model;
using System.ComponentModel;

namespace KoloryWPF.ModelWidoku
{
    public class EdycjaKoloru : INotifyPropertyChanged
    {
        private Kolor kolor = Ustawienia.Czytaj();

        public byte R
        {
            get
            {
                return kolor.R;
            }
            set
            {                
                kolor.R = value;
                //OnPropertyChanged("R", "Color");
                OnPropertyChanged("R");
            }
        }

        public byte G
        {
            get
            {
                return kolor.G;
            }
            set
            {
                kolor.G = value;
                //OnPropertyChanged("G", "Color");
                OnPropertyChanged("G");
            }
        }

        public byte B
        {
            get
            {
                return kolor.B;
            }
            set
            {
                kolor.B = value;
                //OnPropertyChanged("B", "Color");
                OnPropertyChanged("B");
            }
        }

        /*
        public Color Color
        {
            get
            {
                return kolor.ToColor();
            }
        }
        */

        public void Zapisz()
        {
            Ustawienia.Zapisz(kolor);
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if(PropertyChanged != null)
            {
                foreach (string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
            }
        }
    }

    static class Rozszerzenia
    {
        public static Color ToColor(this Kolor kolor)
        {
            return Color.FromRgb(kolor.R, kolor.G, kolor.B);
        }
    }
}
