﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Windows.Media;
using KoloryWPF.Model;
using System.ComponentModel;

namespace KoloryWPF.ModelWidoku
{
    class EdycjaKoloru2 : INotifyPropertyChanged
    {
        private byte r, g, b;

        public byte R
        {
            get
            {
                return r;
            }
            set
            {
                r = value;
                OnPropertyChanged("R", "Color");
            }
        }
        public byte G
        {
            get
            {
                return g;
            }
            set
            {
                g = value;
                OnPropertyChanged("G", "Color");
            }
        }
        public byte B
        {
            get
            {
                return b;
            }
            set
            {
                b = value;
                OnPropertyChanged("B", "Color");
            }
        }

        public EdycjaKoloru2()
        {
            Kolor kolor = Ustawienia.Czytaj();
            R = kolor.R;
            G = kolor.G;
            B = kolor.B;
        }

        public Color Color
        {
            get
            {
                return Color.FromRgb(R, G, B);
            }
        }        

        public void Zapisz()
        {
            Kolor kolor = new Kolor(R, G, B);
            Ustawienia.Zapisz(kolor);
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if (PropertyChanged != null)
            {
                foreach (string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
            }
        }
    }
}
