﻿Imports System.ComponentModel

Namespace KolorowyPasekPostepuVB
    Partial Public Class KolorowyPasekPostepu
        Inherits UserControl
        Public Sub New()
            Me.DoubleBuffered = True
        End Sub

        Private Sub KolorowyPasekPostepu_Paint(sender As Object, e As PaintEventArgs) Handles MyBase.Paint
            Dim g As Graphics = e.Graphics

            Dim cien As New Pen(SystemColors.ControlDark)
            Dim swiatlo As New Pen(SystemColors.ControlLightLight)
            g.DrawLine(cien, 0, Height - 1, 0, 0)
            g.DrawLine(cien, 0, 0, Width - 1, 0)
            g.DrawLine(swiatlo, Width - 1, 0, Width - 1, Height - 1)
            g.DrawLine(swiatlo, Width - 1, Height - 1, 0, Height - 1)

            Const margines As Integer = 2

            Dim procent As Double = (Value - Minimum) / CDbl(Maximum - Minimum)
            Dim szerokosc As Integer = CInt(procent * Width - 2 * margines)

            Dim pedzelPaska As Brush = New SolidBrush(SystemColors.ActiveCaption)

            For ix As Integer = margines To szerokosc - 1
                Dim pioroPaska As New Pen(ColorBegin.Lerp(ix / CSng(Width - 2 * margines), ColorEnd))
                g.DrawLine(pioroPaska, ix, margines, ix, Height - 1 - margines)
            Next
        End Sub

#Region "Pola i własności"
        Private _minimum As Integer = 0
        Private _maximum As Integer = 100
        Private _value As Integer = 0

        <Category("Behavior"), Description("Dolna granica wartości")> _
        Public Property Minimum() As Integer
            Get
                Return _minimum
            End Get
            Set(ByVal value As Integer)
                If value > _maximum Then
                    value = _maximum
                End If
                _minimum = value
                Refresh()
            End Set
        End Property

        <Category("Behavior"), Description("Górna granica wartości")> _
        Public Property Maximum() As Integer
            Get
                Return _maximum
            End Get
            Set(ByVal value As Integer)
                If value < _minimum Then
                    value = _minimum
                End If
                _maximum = value
                Refresh()
            End Set
        End Property

        <Category("Behavior"), Description("Wartość")> _
        Public Property Value() As Integer
            Get
                Return _value
            End Get
            Set(ByVal value As Integer)
                If value < _minimum Then
                    value = _minimum
                End If
                If value > _maximum Then
                    value = _maximum
                End If
                Me._value = value
                OnValueChanged()
                Refresh()
            End Set
        End Property

        Private _colorBegin As Color = Color.Red
        Private _colorEnd As Color = Color.Yellow
        Public Property ColorBegin() As Color
            Get
                Return _colorBegin
            End Get
            Set(ByVal value As Color)
                _colorBegin = value
                Refresh()
            End Set
        End Property
        Public Property ColorEnd() As Color
            Get
                Return _colorEnd
            End Get
            Set(ByVal value As Color)
                _colorEnd = value
                Refresh()
            End Set
        End Property
#End Region

#Region "Zdarzenia"
        Public Delegate Sub ValueChangedEventHandler(sender As Object, e As EventArgs)
        Public Event Value_Changed As ValueChangedEventHandler
        Private Sub OnValueChanged()
            RaiseEvent Value_Changed(Me, New EventArgs())
        End Sub
#End Region
        
    End Class
    Public Module Rozszerzenia

        'Interpolacja
        Private Function Lerp(waga As Single, wartosc1 As Integer, wartosc2 As Integer) As Integer
            Return CInt(Math.Truncate((1 - waga) * wartosc1 + waga * wartosc2))
        End Function
        Public Function Lerp(waga As Single, kolor1 As Color, kolor2 As Color) As Color
            Dim R As Integer = Lerp(waga, kolor1.R, kolor2.R)
            Dim G As Integer = Lerp(waga, kolor1.G, kolor2.G)
            Dim B As Integer = Lerp(waga, kolor1.B, kolor2.B)
            Return Color.FromArgb(R, G, B)
        End Function
        <System.Runtime.CompilerServices.Extension> _
        Public Function Lerp(kolor1 As Color, waga As Single, kolor2 As Color) As Color
            Return Rozszerzenia.Lerp(waga, kolor1, kolor2)
        End Function
        Public Function ObliczPole(r As System.Drawing.Rectangle) As Integer
            Return r.Width * r.Height
        End Function
    End Module
End Namespace