﻿Imports System.Drawing

Namespace KPPVB
    Partial Public Class KPPVB
        Inherits UserControl

        Public Sub New()
            Me.DoubleBuffered = True
            InitializeComponent()
        End Sub

        Private m_minimum As Integer = 0
        Private m_maximum As Integer = 100
        Private m_value As Integer = 0

        Public Property Minimum As Integer
            Get
                Return m_minimum
            End Get
            Set(value As Integer)
                If value > m_maximum Then
                    value = m_maximum
                End If
                m_minimum = value
                Refresh()
            End Set
        End Property

        Public Property Maximum As Integer
            Get
                Return m_maximum
            End Get
            Set(value As Integer)
                If value < m_minimum Then
                    value = m_minimum
                End If
                m_maximum = value
                Refresh()
            End Set
        End Property

        Public Property Value As Integer
            Get
                Return m_value
            End Get
            Set(value As Integer)
                If value < m_minimum Then
                    m_value = m_minimum
                Else
                    If value > m_maximum Then
                        m_value = m_maximum
                    Else
                        m_value = value
                    End If
                End If
                Refresh()
            End Set
        End Property

        Private m_colorBegin As Color = Color.Yellow
        Private m_colorEnd As Color = Color.Red

        Public Property ColorBegin As Color
            Get
                Return m_colorBegin
            End Get
            Set(value As Color)
                m_colorBegin = value
                Refresh()
            End Set
        End Property

        Public Property ColorEnd As Color
            Get
                Return m_colorEnd
            End Get
            Set(value As Color)
                m_colorEnd = value
                Refresh()
            End Set
        End Property

        Private Sub KPPVB_Paint(sender As Object, e As PaintEventArgs) Handles MyBase.Paint
            Dim g As Graphics = e.Graphics
            Dim cien As New Pen(SystemColors.ControlDark)
            Dim swiatlo As New Pen(SystemColors.ControlLightLight)
            g.DrawLine(cien, 0, Height - 1, 0, 0)
            g.DrawLine(cien, 0, 0, Width - 1, 0)
            g.DrawLine(swiatlo, Width - 1, 0, Width - 1, Height - 1)
            g.DrawLine(swiatlo, Width - 1, Height - 1, 0, Height - 1)


            Dim procent As Double = (Value - Minimum) / CDbl(Maximum - Minimum)
            Const margines As Integer = 2
            Dim szerokosc As Integer = CInt(Math.Truncate(procent * Width - 2 * margines))

            Dim pedzelPaska As Brush = New SolidBrush(SystemColors.ActiveCaption)
            For ix As Integer = margines To szerokosc - 1
                Dim pioroPaska As New Pen(Rozszerzenia.Lerp(ix / CSng(Width - 2 * margines), ColorBegin, ColorEnd))
                g.DrawLine(pioroPaska, ix, margines, ix, Height - 1 - margines)
            Next
        End Sub
    End Class

    NotInheritable Class Rozszerzenia
        Private Sub New()
        End Sub
        Private Shared Function Lerp(waga As Single, wartość1 As Integer, wartość2 As Integer) As Integer
            Return CInt(Math.Truncate((1 - waga) * wartość1 + waga * wartość2))
        End Function

        Public Shared Function Lerp(waga As Single, kolor1 As Color, kolor2 As Color) As Color
            Dim R As Integer = Lerp(waga, kolor1.R, kolor2.R)
            Dim G As Integer = Lerp(waga, kolor1.G, kolor2.G)
            Dim B As Integer = Lerp(waga, kolor1.B, kolor2.B)
            Return Color.FromArgb(R, G, B)
        End Function

        Public Shared Function ObliczPole(r As System.Drawing.Rectangle) As Integer
            Return r.Width * r.Height
        End Function
    End Class

End Namespace

