﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Notatnik
{
    class Znajdz
    {
        static public string _fraza = "";
        static public string _zamiennik = "";
        static public int _pozycja = 0;
        static public bool _rButtonStatus = true; //radioButton "W dół"
        static public bool _chBoxStatus = false; //Zaznaczony
        static public bool _czyKliknietyZnajdz = false;
        static public int _pozycjaStartowa = 0;

        static public void znajdzFraze(string fraza, int pozycja, TextBox txtBox)
        {
            string tekst = txtBox.Text;
            int dlugoscFrazy = fraza.Length;
            string lowFraza, lowTekst;
            lowFraza = fraza.ToLower();
            lowTekst = tekst.ToLower();

            if (!_chBoxStatus)
            {
                fraza = lowFraza;
                tekst = lowTekst;
            }

            if (_rButtonStatus)
            {
                pozycja = tekst.IndexOf(fraza, _pozycja);
                if (pozycja != -1)
                {
                    _pozycja = pozycja + dlugoscFrazy;
                    txtBox.Select(pozycja, dlugoscFrazy);
                    _pozycjaStartowa = pozycja;
                }
                else
                    MessageBox.Show(
                    "Nie można odnaleźć \"" + _fraza + "\"",
                    "Notatnik",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            else if (!_rButtonStatus)
            {
                pozycja = tekst.LastIndexOf(fraza, _pozycja);
                if (pozycja != -1)
                {
                    _pozycja = pozycja;
                    txtBox.Select(pozycja, dlugoscFrazy);
                }
                else
                    MessageBox.Show(
                    "Nie można odnaleźć \"" + _fraza + "\"",
                    "Notatnik",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            txtBox.ScrollToCaret();
        }

        static public void znajdzFraze(string fraza, string zamiennik, int pozycja, TextBox txtBox)
        {
            string tekst = txtBox.Text;
            int dlugoscFrazy = fraza.Length;
            string lowFraza, lowTekst, lowZamiennik;
            lowFraza = fraza.ToLower();
            lowTekst = tekst.ToLower();
            lowZamiennik = zamiennik.ToLower();

            if (!_chBoxStatus)
            {
                fraza = lowFraza;
                tekst = lowTekst;
            }

            if (!_czyKliknietyZnajdz)
                pozycja = tekst.IndexOf(fraza, txtBox.SelectionStart + txtBox.SelectionLength);
            else
                pozycja = tekst.IndexOf(fraza, _pozycjaStartowa);

            if (pozycja != -1)
            {
                _pozycja = pozycja + zamiennik.Length;
                txtBox.Select(pozycja, dlugoscFrazy);
                txtBox.SelectedText = zamiennik;
                txtBox.Select(pozycja, zamiennik.Length);     
            }
            else
                MessageBox.Show(
                "Nie można odnaleźć \"" + _fraza + "\"",
                "Notatnik",
                MessageBoxButtons.OK,
                MessageBoxIcon.Information);

            txtBox.ScrollToCaret();
        }
    }
}
