﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Notatnik
{
    public partial class Zamien : Form
    {
        //public Zamien()
        //{
        //    InitializeComponent();
        //}
        
        private NotatnikForm mainForm = null;
        public Zamien(Form callingForm)
        {
            mainForm = callingForm as NotatnikForm;
            InitializeComponent();

            textBox1.Text = Znajdz._fraza;
            textBox2.Text = Znajdz._zamiennik;
            checkBoxUwzglednijWielkosc.Checked = Znajdz._chBoxStatus;
            Znajdz._pozycja = mainForm.txtBox.SelectionStart;
            if (Znajdz._pozycja != 0)
                Znajdz._pozycja = this.mainForm.txtBox.SelectionStart + this.mainForm.txtBox.SelectionLength;
            Znajdz._rButtonStatus = true; //radioButton "W dół"
        }

        private void buttonZamienWszystko_Click(object sender, EventArgs e)
        {
            string tBox1 = textBox1.Text;
            string tBox2 = textBox2.Text;
            
            if (!Znajdz._chBoxStatus)
            {
                mainForm.txtBox.Text = mainForm.txtBox.Text.ToLower();
                tBox1 = textBox1.Text.ToLower();
            }
            
            mainForm.txtBox.Text = mainForm.txtBox.Text.Replace(tBox1,tBox2);
        }

        private void buttonZnajdzNastepny_Click(object sender, EventArgs e)
        {
            var fraza = textBox1.Text;
            Znajdz._fraza = fraza;
            Znajdz._czyKliknietyZnajdz = true;

            Znajdz.znajdzFraze(fraza,Znajdz._pozycja,mainForm.txtBox);
        }

        private void buttonZamien_Click(object sender, EventArgs e)
        {
            var fraza = textBox1.Text;
            Znajdz._fraza = fraza;
            
            Znajdz.znajdzFraze(fraza, textBox2.Text, Znajdz._pozycja, mainForm.txtBox);
            Znajdz._czyKliknietyZnajdz = false;
        }

        private void checkBoxUwzglednijWielkosc_Click(object sender, EventArgs e)
        {
            if (checkBoxUwzglednijWielkosc.Checked)
                Znajdz._chBoxStatus = true;     //zaznaczony
            else if (!checkBoxUwzglednijWielkosc.Checked)
                Znajdz._chBoxStatus = false;    //niezaznaczony
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            if(textBox1.Text != "")
            {
                buttonZnajdzNastepny.Enabled = true;
                buttonZamien.Enabled = true;
                buttonZamienWszystko.Enabled = true;
            }
            else
            {
                buttonZnajdzNastepny.Enabled = false;
                buttonZamien.Enabled = false;
                buttonZamienWszystko.Enabled = false;
            }
        }

        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)13)
            {
                buttonZnajdzNastepny_Click(sender, e);
                buttonZnajdzNastepny.Focus();
            }
        }

        private void buttonAnuluj_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}