﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Notatnik
{
    public partial class PrzejdzDo : Form
    {
        //public PrzejdzDo()
        //{
        //    InitializeComponent();
        //}

        private NotatnikForm mainForm = null;
        public PrzejdzDo(Form callingForm)
        {
            mainForm = callingForm as NotatnikForm;
            InitializeComponent();
            
            textBox1.Text = (mainForm.txtBox.GetLineFromCharIndex(mainForm.txtBox.SelectionStart)+1).ToString();
        }

        private void buttonPrzejdzDo_Click(object sender, EventArgs e)
        {
            if (Convert.ToInt32(textBox1.Text) > mainForm.txtBox.Lines.Length)
                MessageBox.Show(
                    "Maksymalna ilość wierszy to: " + mainForm.txtBox.Lines.Length + "!",
                    "Notatnik",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            else if (Convert.ToInt32(textBox1.Text) < 1)
                MessageBox.Show(
                    "Minimalna ilość wierszy to: 1!",
                    "Notatnik",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            else
            {
                int index = mainForm.txtBox.GetFirstCharIndexFromLine(Convert.ToInt32(textBox1.Text) - 1);
                mainForm.txtBox.Select(index, 0);
                Close();
            }
        }

        private void buttonAnuluj_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!char.IsDigit(e.KeyChar) && !(e.KeyChar == (char)13))
            {
                e.Handled = true;
                textBox1.Text.Remove(textBox1.Text.Length - 1);
                MessageBox.Show(
                    "Tylko wartości numeryczne!",
                    "Notatnik",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            else if (e.KeyChar == (char)13)
                buttonPrzejdzDo_Click(sender, e);
        }
    }
}
