﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Notatnik
{
    static class PlikiTekstowe
    {
        public static bool CzytajPlikTekstowy(string sciezkaPliku, out string[] wiersze)
        {
            List<string> listawierszy = new List<string>();

            StreamReader sr = null;
            try
            {
                sr = new StreamReader(sciezkaPliku, Encoding.Default);
                string wiersz = null;
                while ((wiersz = sr.ReadLine()) != null)
                    listawierszy.Add(wiersz);
                wiersze = listawierszy.ToArray();
                return true;
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd!" + exc.Message,
                    "Błąd",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                wiersze = null;
                return false;
            }
            finally
            {
                if (sr != null) sr.Close();
            }
            #region Przyklad z using
            //using(StreamReader sr = new StreamReader(sciezkaPliku))
            //{

            //}
            #endregion
        }

        public static bool ZapiszDoPlikuTekstowego(string sciezkaPliku, string[] wiersze)
        {
            try
            {
                using (StreamWriter sw = new StreamWriter(sciezkaPliku))
                {
                    foreach (string wiersz in wiersze) sw.WriteLine(wiersze);
                }
                return true;
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd!" + exc.Message,
                    "Błąd",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                wiersze = null;
                return false;
            }
        }

        public static void LoadFromFile(this TextBox textBox, string filePath)
        {
            string[] wiersze;
            if (PlikiTekstowe.CzytajPlikTekstowy(filePath, out wiersze))
                textBox.Lines = wiersze;
        }

        public static void SaveToFile(this TextBox textBox, string sciezkaPliku)
        {
            ZapiszDoPlikuTekstowego(sciezkaPliku, textBox.Lines);
        }
    }
}
