﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Notatnik
{
    public partial class NotatnikForm : Form
    {
        public TextBox txtBox
        {
            get { return textBox1; }
            set { textBox1 = value; }
        }
        string sciezkaPliku = null;

        public NotatnikForm()
        {
            InitializeComponent();

            saveFileDialog1.Filter = openFileDialog1.Filter;

            //sprawdzenie zawartości schowka
            if (Clipboard.GetDataObject().GetDataPresent(DataFormats.Text) == true)
                wklejToolStripMenuItem.Enabled = true;
            else
                wklejToolStripMenuItem.Enabled = false;
        }

        #region Z zajęć

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (sciezkaPliku != null) openFileDialog1.FileName = sciezkaPliku;
                DialogResult dr = openFileDialog1.ShowDialog();
                if (dr == DialogResult.OK)
                {
                    string[] wiersze;
                    if (PlikiTekstowe.CzytajPlikTekstowy(openFileDialog1.FileName, out wiersze))
                    {
                        sciezkaPliku = openFileDialog1.FileName;
                        textBox1.Lines = wiersze;
                        toolStripStatusLabel1.Text = "Wczytano plik: " + sciezkaPliku;
                        statusStrip1.BackColor = Color.Green;
                        textBox1.ReadOnly = openFileDialog1.ReadOnlyChecked;
                    }
                    else
                    {
                        toolStripStatusLabel1.Text = "Nie wczytano pliku: " + sciezkaPliku;
                        statusStrip1.BackColor = Color.Red;
                    }
                }

            //openFileDialog1.FileName
            //textBox1.Lines = CzytajPlikTekstowy(@"D:\Projekty\VSProjects\Kurs C#\Notatnik\sotest.txt");
        }

        private bool zapisywanie()
        {
            if (sciezkaPliku != null)
            {
                saveFileDialog1.InitialDirectory = Path.GetDirectoryName(sciezkaPliku);
                saveFileDialog1.FileName = Path.GetFileName(sciezkaPliku);
            }
            DialogResult dr = saveFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                if (PlikiTekstowe.ZapiszDoPlikuTekstowego(saveFileDialog1.FileName, textBox1.Lines))
                {
                    sciezkaPliku = saveFileDialog1.FileName;
                    toolStripStatusLabel1.Text = "Tekst zapisany do pliku " + sciezkaPliku;
                    statusStrip1.BackColor = Color.Green;
                    return true;
                }
                else
                {
                    toolStripStatusLabel1.Text = "Nie powiodła się próba zapisu do pliku " + sciezkaPliku;
                    statusStrip1.BackColor = Color.Red;
                    return false;
                }
            }
            else
                return false;
        }
        
        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (sciezkaPliku != null) PlikiTekstowe.ZapiszDoPlikuTekstowego(sciezkaPliku, textBox1.Lines);
            else zapiszJakoToolStripMenuItem_Click(sender, e);
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            zapisywanie();
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (textBox1.Text == "") return;

            DialogResult dr = MessageBox.Show(
                "Czy chcesz zapisać zmiany w pliku?",
                this.Text,
                MessageBoxButtons.YesNoCancel,
                MessageBoxIcon.Question,
                MessageBoxDefaultButton.Button3);

            if (dr != DialogResult.Cancel)
                if (dr == DialogResult.No || zapisywanie())
                    textBox1.Text = "";

            //switch (dr)
            //{
            //    case DialogResult.Yes:
            //        zapiszJakoToolStripMenuItem_Click(sender, e);
            //        // konkurs - jak zrobić elegancko (bez dodawania flagi i bez powtarzania kodu DRY)
            //        break;
            //    case DialogResult.No:
            //        break;
            //    case DialogResult.Cancel:
            //        return;
            //}
            //textBox1.Text = "";
        }

        private void zawijanieWierszyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //zawijanieWierszyToolStripMenuItem.Checked = !zawijanieWierszyToolStripMenuItem.Checked;
            textBox1.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
        }

        private void pasekStanuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            statusStrip1.Visible = pasekStanuToolStripMenuItem.Checked;
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = textBox1.Font;
            fontDialog1.Color = textBox1.ForeColor;
            if(fontDialog1.ShowDialog()==DialogResult.OK)
            {
                textBox1.Font = fontDialog1.Font;
                textBox1.ForeColor = fontDialog1.Color;
            }
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = textBox1.BackColor;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.BackColor = colorDialog1.Color;
            }
        }

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Undo();
            //textBox1.ClearUndo();
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Cut();
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Copy();
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Paste();
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = "";
        }

        private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectAll();
        }

        private void godzinadataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = DateTime.Now.ToString();
        }
        #endregion

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            if (textBox1.CanUndo == true)
                cofnijToolStripMenuItem.Enabled = true;
            else
                cofnijToolStripMenuItem.Enabled = false;
            if (textBox1.SelectedText != "")
                wytnijToolStripMenuItem.Enabled = true;
            else
                wytnijToolStripMenuItem.Enabled = false;
            if (textBox1.SelectionLength > 0)
            {
                kopiujToolStripMenuItem.Enabled = true;
                usuńToolStripMenuItem.Enabled = true;
            }
            else
            {
                kopiujToolStripMenuItem.Enabled = false;
                usuńToolStripMenuItem.Enabled = false;
            }
            if (Clipboard.GetDataObject().GetDataPresent(DataFormats.Text) == true)
                wklejToolStripMenuItem.Enabled = true;
            else
                wklejToolStripMenuItem.Enabled = false;
            if (textBox1.Text != "")
            {
                znajdzToolStripMenuItem.Enabled = true;
                znajdzNastepnyToolStripMenuItem.Enabled = true;
                zamienToolStripMenuItem.Enabled = true;
            }
            else
            {
                znajdzToolStripMenuItem.Enabled = false;
                znajdzNastepnyToolStripMenuItem.Enabled = false;
                zamienToolStripMenuItem.Enabled = false;
            }
            Znajdz._pozycja = textBox1.SelectionStart;
        }

        private void znajdzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ZnajdowanieForm Znajdowanie = new ZnajdowanieForm(this);
            Znajdowanie.ShowDialog();          
        }

        private void znajdzNastepnyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Znajdz.znajdzFraze(Znajdz._fraza, Znajdz._pozycja, textBox1);
        }

        private void zamienToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Zamien Zamiana = new Zamien(this);
            Zamiana.Show();
        }

        private void przejdzDoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            PrzejdzDo Przejdz = new PrzejdzDo(this);
            Przejdz.ShowDialog();
        }
    }
}
