﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace kolory
{
    public partial class Form1 : Form
    {
        enum ColorMode { RGB, HSV };

        bool updatePanelColor = true;
        ColorMode mode;

        public Form1()
        {
            InitializeComponent();

            panel.Click += panel_Click;
            panel.Anchor = (AnchorStyles.Left | AnchorStyles.Right | AnchorStyles.Bottom | AnchorStyles.Top);

            groupBox1.Text = "Tryb";
            radioButton1.Text = "RGB";
            radioButton1.Checked = true;
            radioButton1.CheckedChanged += radioButton1_CheckedChanged;
            radioButton2.Text = "HSV";

            label4.Text = "a";
            label1.Font = label2.Font = label3.Font = label5.Font = label6.Font = label7.Font = new System.Drawing.Font("Arial", 22);
            label4.Font = new System.Drawing.Font("Symbol", 22);
            label1.Anchor = label2.Anchor = label3.Anchor = label4.Anchor = (AnchorStyles.Left | AnchorStyles.Bottom);
            label5.Anchor = label6.Anchor = label7.Anchor = (AnchorStyles.Right | AnchorStyles.Bottom);

            trackBar1.Anchor = trackBar2.Anchor = trackBar3.Anchor = trackBar4.Anchor = (AnchorStyles.Left | AnchorStyles.Right | AnchorStyles.Bottom);
            trackBar1.Value = trackBar2.Value = trackBar3.Value = 0;
            trackBar1.ValueChanged += new EventHandler(trackBar_ValueChanged);
            trackBar2.ValueChanged += new EventHandler(trackBar_ValueChanged);
            trackBar3.ValueChanged += new EventHandler(trackBar_ValueChanged);

            trackBar4.Minimum = 25;
            trackBar4.Maximum = 100;
            trackBar4.ValueChanged += new EventHandler(trackBar4_ValueChanged);
            trackBar4.Value = 90;

            this.StartPosition = FormStartPosition.CenterScreen;
            this.Text = "Kolory";
            this.Icon = new Icon("icon.ico", new Size(10, 10));
            this.MinimumSize = new System.Drawing.Size(320, 240);
            this.KeyPreview = true;
            this.FormClosed += new FormClosedEventHandler(Form1_FormClosed);
            this.KeyDown += Form1_KeyDown;
            this.Paint += Form1_Paint;

            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            this.SetStyle(ControlStyles.UserPaint, true);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);

            trackBar_ValueChanged(null, null);
            radioButton1_CheckedChanged(radioButton1, null);
        }

        Color HSVToRGB(float h, float s, float v)
        {
            float r, g, b;
            int i;
            float f, p, q, t;

            if (s == 0)
                r = g = b = v;
            else
            {
                h /= 60;
                i = (int)Math.Floor(h);
                f = h - i;
                p = v * (1 - s);
                q = v * (1 - s * f);
                t = v * (1 - s * (1 - f));

                switch (i)
                {
                    case 0:
                        r = v;
                        g = t;
                        b = p;
                        break;
                    case 1:
                        r = q;
                        g = v;
                        b = p;
                        break;
                    case 2:
                        r = p;
                        g = v;
                        b = t;
                        break;
                    case 3:
                        r = p;
                        g = q;
                        b = v;
                        break;
                    case 4:
                        r = t;
                        g = p;
                        b = v;
                        break;
                    default:
                        r = v;
                        g = p;
                        b = q;
                        break;
                }
            }

            r *= 255;
            g *= 255;
            b *= 255;

            return Color.FromArgb((int)r, (int)g, (int)b);
        }

        void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Control && e.KeyCode == Keys.C)
                Clipboard.SetText("#" + label5.Text + label6.Text + label7.Text);
        }

        void Form1_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;

            switch (mode)
            {
                case ColorMode.HSV:
                    Point location = trackBar1.Location;

                    for (int x = 0; x < trackBar1.ClientRectangle.Width; x++)
                        g.DrawLine(new Pen(HSVToRGB(((float)x / trackBar1.ClientRectangle.Width) * 360, 1, 1)), new Point(location.X + x, location.Y), new Point(location.X + x, location.Y - 5));

                    location = trackBar2.Location;

                    for (int x = 0; x < trackBar2.ClientRectangle.Width; x++)
                        g.DrawLine(new Pen(HSVToRGB(trackBar1.Value, (float)x / trackBar2.ClientRectangle.Width, 1)), new Point(location.X + x, location.Y), new Point(location.X + x, location.Y - 5));

                    location = trackBar3.Location;

                    for (int x = 0; x < trackBar3.ClientRectangle.Width; x++)
                        g.DrawLine(new Pen(HSVToRGB(trackBar1.Value, 1, (float)x / trackBar3.ClientRectangle.Width)), new Point(location.X + x, location.Y), new Point(location.X + x, location.Y - 5));

                    break;
            }
        }

        void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            for (; this.Opacity > 0; this.Opacity -= 0.005)
                System.Threading.Thread.Sleep(1);
        }

        void trackBar_ValueChanged(object sender, EventArgs e)
        {
            if (updatePanelColor)
            {
                string labelFormat = String.Empty;
                Color color = Color.Transparent;
                int a = trackBar1.Value;
                int b = trackBar2.Value;
                int c = trackBar3.Value;

                switch (mode)
                {
                    case ColorMode.RGB:
                        color = Color.FromArgb(a, b, c);
                        labelFormat = "X2";
                        break;
                    case ColorMode.HSV:
                        color = HSVToRGB(a, b / 100f, c / 100f);
                        break;
                }

                this.Invalidate();

                panel.BackColor = color;
                label5.Text = trackBar1.Value.ToString(labelFormat);
                label6.Text = trackBar2.Value.ToString(labelFormat);
                label7.Text = trackBar3.Value.ToString(labelFormat);
            }
        }

        void trackBar4_ValueChanged(object sender, EventArgs e)
        {
            TrackBar trackBar = (TrackBar)sender;

            this.Opacity = trackBar.Value / (double)trackBar.Maximum;
        }

        void panel_Click(object sender, EventArgs e)
        {
            colorDialog.Color = panel.BackColor;

            DialogResult result = colorDialog.ShowDialog();

            switch (result)
            {
                case System.Windows.Forms.DialogResult.OK:
                    panel.BackColor = colorDialog.Color;
                    updatePanelColor = false;

                    switch (mode)
                    {
                        case ColorMode.RGB:
                            trackBar1.Value = panel.BackColor.R;
                            trackBar2.Value = panel.BackColor.G;
                            trackBar3.Value = panel.BackColor.B;
                            break;
                        case ColorMode.HSV:
                            trackBar1.Value = (int)panel.BackColor.GetHue();
                            trackBar2.Value = (int)(panel.BackColor.GetSaturation() * 100);
                            trackBar3.Value = (int)(panel.BackColor.GetBrightness() * 100);

                            this.Invalidate();
                            break;
                    }

                    updatePanelColor = true;
                    break;
            }
        }

        void radioButton1_CheckedChanged(object sender, EventArgs e)
        {
            if (((RadioButton)sender).Checked)
            {
                mode = ColorMode.RGB;
                label1.Text = "R";
                label2.Text = "G";
                label3.Text = "B";
                label1.ForeColor = Color.Red;
                label2.ForeColor = Color.Green;
                label3.ForeColor = Color.Blue;
                trackBar1.Maximum = trackBar2.Maximum = trackBar3.Maximum = 255;
            }
            else
            {
                mode = ColorMode.HSV;
                label1.Text = "H";
                label2.Text = "S";
                label3.Text = "V";
                label1.ForeColor = label2.ForeColor = label3.ForeColor = Color.Black;
                trackBar1.Maximum = 360;
                trackBar2.Maximum = trackBar3.Maximum = 100;

                this.Invalidate();
            }

            trackBar_ValueChanged(null, null);
        }
    }
}