﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Kolory
{
    public partial class Form1 : Form
    {
        bool czyAktualizowacKolorPanelu = true;
        
        public Form1()
        {
            InitializeComponent();
        }

        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {
            if (czyAktualizowacKolorPanelu)
            {
                if (radioButton1.Checked)
                {
                    panel1.BackColor = Color.FromArgb(trackBar1.Value, trackBar2.Value, trackBar3.Value);

                    label8.ForeColor = (panel1.BackColor.GetBrightness() < 0.5) ? Color.White : Color.Black;

                    TrackBar trackBar = sender as TrackBar;
                    if (trackBar == trackBar1) label5.Text = trackBar1.Value.ToString();
                    if (trackBar == trackBar2) label6.Text = trackBar2.Value.ToString();
                    if (trackBar == trackBar3) label7.Text = trackBar3.Value.ToString();
                }
                else if (radioButton2.Checked)
                {
                    float hue, sat, bri;

                    hue = (float)trackBar1.Value;
                    sat = (float)trackBar2.Value/100;
                    bri = (float)trackBar3.Value/100;

                    panel1.BackColor = ColorFromAhsb(255, hue, sat, bri);

                    label8.ForeColor = (panel1.BackColor.GetBrightness() < 0.5) ? Color.White : Color.Black;
                    
                    TrackBar trackBar = sender as TrackBar;
                    if (trackBar == trackBar1) label5.Text = trackBar1.Value.ToString();
                    if (trackBar == trackBar2) label6.Text = trackBar2.Value.ToString();
                    if (trackBar == trackBar3) label7.Text = trackBar3.Value.ToString();
                }
            }
        }
        private void Form1_Load(object sender, EventArgs e)
        {
            trackBar1_ValueChanged(null, null);
            trackBar4.Value = (int)(this.Opacity * trackBar4.Maximum);

            Properties.Settings ustawienia = new Properties.Settings();
            // współrzędne
            this.Left = ustawienia.Left;
            this.Top = ustawienia.Top;
            // rozmiar
            this.Width = ustawienia.Width;
            this.Height = ustawienia.Height;
            // zaznaczenie kontrolek zmiany trybu
            this.radioButton1.Checked = ustawienia.RB1;
            this.radioButton2.Checked = ustawienia.RB2;
            // maksymalne wartości, wartości poprzednio używane oraz aktywność trybu
            if (radioButton1.Checked)
            {
                radioButton1.Enabled = ustawienia.RB1Enable;
                radioButton2.Enabled = ustawienia.RB2Enable;
                trackBar1.Maximum = ustawienia.RGBMax;
                trackBar2.Maximum = ustawienia.RGBMax;
                trackBar3.Maximum = ustawienia.RGBMax;
                trackBar1.Value = ustawienia.R;
                trackBar2.Value = ustawienia.G;
                trackBar3.Value = ustawienia.B;
            }
            else if (radioButton2.Checked)
            {
                radioButton1.Enabled = ustawienia.RB1Enable;
                radioButton2.Enabled = ustawienia.RB2Enable;
                trackBar1.Maximum = ustawienia.HMax;
                trackBar2.Maximum = ustawienia.SBMax;
                trackBar3.Maximum = ustawienia.SBMax;
                trackBar1.Value = ustawienia.H;
                trackBar2.Value = ustawienia.S;
                trackBar3.Value = ustawienia.V;
                pictureBox1.Visible = true;
            }
            // nazwy suwaków
            label1.Text = ustawienia.TB1Name;
            label2.Text = ustawienia.TB2Name;
            label3.Text = ustawienia.TB3Name;
            // wyświetlane wartości suwaków
            label5.Text = ustawienia.TB1Txt;
            label6.Text = ustawienia.TB2Txt;
            label7.Text = ustawienia.TB3Txt;
            // kolory nazw suwaków
            label1.ForeColor = ustawienia.Color1;
            label2.ForeColor = ustawienia.Color2;
            label3.ForeColor = ustawienia.Color3;
        }
        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            Properties.Settings ustawienia = new Properties.Settings();
            // współrzędne
            ustawienia.Left = this.Left;
            ustawienia.Top = this.Top;
            // rozmiar
            ustawienia.Width = this.Width;
            ustawienia.Height = this.Height;
            // wartości poprzednio używane
            ustawienia.R = (byte)trackBar1.Value;
            ustawienia.G = (byte)trackBar2.Value;
            ustawienia.B = (byte)trackBar3.Value;
            ustawienia.H = trackBar1.Value;
            ustawienia.S = trackBar2.Value;
            ustawienia.V = trackBar3.Value;
            // maksymalne wartości
            ustawienia.RGBMax = 255;
            ustawienia.HMax = 360;
            ustawienia.SBMax = 100;
            // nazwy suwaków
            ustawienia.TB1Name = label1.Text;
            ustawienia.TB2Name = label2.Text;
            ustawienia.TB3Name = label3.Text;
            // wyświetlane wartości suwaków
            ustawienia.TB1Txt = label5.Text;
            ustawienia.TB2Txt = label6.Text;
            ustawienia.TB3Txt = label7.Text;
            // zaznaczenie kontrolek zmiany trybu
            ustawienia.RB1 = radioButton1.Checked;
            ustawienia.RB2 = radioButton2.Checked;
            // kolory nazw suwaków
            ustawienia.Color1 = label1.ForeColor;
            ustawienia.Color2 = label2.ForeColor;
            ustawienia.Color3 = label3.ForeColor;
            // aktywność trybów
            ustawienia.RB1Enable = radioButton1.Enabled;
            ustawienia.RB2Enable = radioButton2.Enabled;
            // zapisanie wartości
            ustawienia.Save();

            for (; this.Opacity > 0.0; this.Opacity -= 0.005) System.Threading.Thread.Sleep(1);
        }
        private void trackBar4_Scroll(object sender, EventArgs e)
        {
            TrackBar tb = sender as TrackBar;
            this.Opacity = tb.Value / (double)tb.Maximum;
            
        }
        private void Form1_MouseEnter(object sender, EventArgs e)
        {
            this.Opacity = 1;
        }
        private void Form1_MouseLeave(object sender, EventArgs e)
        {
            this.Opacity = trackBar4.Value / (double)trackBar4.Maximum;
        }
        private void panel1_MouseEnter(object sender, EventArgs e)
        {
            this.Opacity = 1;
            label8.Visible = true;
        }
        private void panel1_MouseLeave(object sender, EventArgs e)
        {
            label8.Visible = false;
            this.Opacity = trackBar4.Value / (double)trackBar4.Maximum;
        }
        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Control && e.KeyCode == Keys.C)
            {
                Clipboard.SetText("#" + trackBar1.Value.ToString("X2") + trackBar2.Value.ToString("X2") + trackBar3.Value.ToString("X2"));
            }

        }
        private void panel1_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = panel1.BackColor;
            DialogResult dr = colorDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                panel1.BackColor = colorDialog1.Color;
                czyAktualizowacKolorPanelu = false;
                if (radioButton1.Checked)
                {
                    trackBar1.Value = panel1.BackColor.R;
                    trackBar2.Value = panel1.BackColor.G;
                    trackBar3.Value = panel1.BackColor.B;
                }
                else if (radioButton2.Checked)
                {
                    trackBar1.Value = (int)panel1.BackColor.GetHue();
                    trackBar2.Value = (int)(panel1.BackColor.GetSaturation() * 100);
                    trackBar3.Value = (int)(panel1.BackColor.GetBrightness() * 100);
                }
                czyAktualizowacKolorPanelu = true;
            }
        }
        private void radioButton1_Click(object sender, EventArgs e)
        {
            radioButton1.Enabled = false;
            radioButton2.Enabled = true;
            label1.Text = "R:";
            label2.Text = "G:";
            label3.Text = "B:";
            label1.ForeColor = Color.Red;
            label2.ForeColor = Color.Green;
            label3.ForeColor = Color.Blue;
            trackBar1.Maximum = 255;
            trackBar2.Maximum = 255;
            trackBar3.Maximum = 255;
            pictureBox1.Visible = false;

            czyAktualizowacKolorPanelu = false;
                trackBar1.Value = panel1.BackColor.R;
                trackBar2.Value = panel1.BackColor.G;
                trackBar3.Value = panel1.BackColor.B;
                label5.Text = trackBar1.Value.ToString();
                label6.Text = trackBar2.Value.ToString();
                label7.Text = trackBar3.Value.ToString();
            czyAktualizowacKolorPanelu = true;
        }
        private void radioButton2_Click(object sender, EventArgs e)
        {
            radioButton2.Enabled = false;
            radioButton1.Enabled = true;
            label1.Text = "H:";
            label2.Text = "S:";
            label1.ForeColor = Color.Black;
            label2.ForeColor = Color.Black;
            label3.ForeColor = Color.Black;
            trackBar1.Maximum = 360;
            trackBar2.Maximum = 100;
            trackBar3.Maximum = 100;
            pictureBox1.Visible = true;

            czyAktualizowacKolorPanelu = false;
                trackBar1.Value = (int)panel1.BackColor.GetHue();
                trackBar2.Value = (int)(panel1.BackColor.GetSaturation()*100);
                trackBar3.Value = (int)(panel1.BackColor.GetBrightness()*100);
                label5.Text = trackBar1.Value.ToString();
                label6.Text = trackBar2.Value.ToString();
                label7.Text = trackBar3.Value.ToString();
            czyAktualizowacKolorPanelu = true;
                
        }
        public static Color ColorFromAhsb(int a, float h, float s, float b)
        {
            if (s == 0)
                return Color.FromArgb(a, Convert.ToInt32(b * 255), Convert.ToInt32(b * 255), Convert.ToInt32(b * 255));

            float fMax, fMid, fMin;
            int iSextant, iMax, iMid, iMin;

            if (b > 0.5)
            {
                fMax = b - (b * s) + s;
                fMin = b + (b * s) - s;
            }
            else
            {
                fMax = b + (b * s);
                fMin = b - (b * s);
            }

            iSextant = (int)Math.Floor(h / 60f);
            
            if (h >= 300f)
                h -= 360f;

            h /= 60f;
            h -= 2f * (float)Math.Floor(((iSextant + 1f) % 6f) / 2f);
            
            if (0 == iSextant % 2)
            {
                fMid = h * (fMax - fMin) + fMin;
            }
            else
            {
                fMid = fMin - h * (fMax - fMin);
            }

            iMax = Convert.ToInt32(fMax * 255);
            iMid = Convert.ToInt32(fMid * 255);
            iMin = Convert.ToInt32(fMin * 255);

            switch (iSextant)
            {
                case 1:
                    return Color.FromArgb(a, iMid, iMax, iMin);
                case 2:
                    return Color.FromArgb(a, iMin, iMax, iMid);
                case 3:
                    return Color.FromArgb(a, iMin, iMid, iMax);
                case 4:
                    return Color.FromArgb(a, iMid, iMin, iMax);
                case 5:
                    return Color.FromArgb(a, iMax, iMin, iMid);
                default:
                    return Color.FromArgb(a, iMax, iMid, iMin);
            }
        }
    }
}