﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Drawing;

namespace Kolory
{
    public partial class Form1 : Form
    {
        bool czyAktualizowaćKolorPanelu = true;

        public Form1()
        {
            InitializeComponent();
        }

        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {
            if(czyAktualizowaćKolorPanelu)
                if (radioButton1.Checked)
                {
                    panel1.BackColor = Color.FromArgb(trackBar1.Value, trackBar2.Value, trackBar3.Value);
                    //if (panel1.BackColor.GetBrightness() < 0.5) label8.ForeColor = Color.White;
                    //else label8.ForeColor = Color.Black;
                    label8.ForeColor = (panel1.BackColor.GetBrightness() < 0.5) ? Color.White : Color.Black;

                    //TrackBar trackBar = null;
                    //if(sender is TrackBar)  trackBar = (TrackBar)sender;
                    TrackBar trackBar = sender as TrackBar;
                    if (trackBar == trackBar1)
                    {
                        label5.Text = trackBar.Value.ToString();
                        //if (trackBar.Value < 16) label5.Text = "0" + label5.Text;
                    }
                    if (trackBar == trackBar2) label6.Text = trackBar.Value.ToString();
                    if (trackBar == trackBar3) label7.Text = trackBar.Value.ToString();
                }
                else if (radioButton2.Checked)
                {
                    double hue, sat, val;
                    label8.ForeColor = (panel1.BackColor.GetBrightness() < 0.5) ? Color.White : Color.Black;
                    hue = trackBar1.Value;
                    sat = (double)trackBar2.Value / 100;
                    val = (double)trackBar3.Value / 100;

                    
                    panel1.BackColor = ColorFromHSV(trackBar1.Value, sat,val);
                    //TrackBar trackBar = null;
                    //if(sender is TrackBar)  trackBar = (TrackBar)sender;
                    TrackBar trackBar = sender as TrackBar;
                    if (trackBar == trackBar1)
                    {
                        label5.Text = trackBar.Value.ToString();
                        //if (trackBar.Value < 16) label5.Text = "0" + label5.Text;
                    }
                    if (trackBar == trackBar2) label6.Text = trackBar.Value.ToString();
                    if (trackBar == trackBar3) label7.Text = trackBar.Value.ToString();
                }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            trackBar1_ValueChanged(null, null);
            trackBar4.Value = (int)(this.Opacity * trackBar4.Maximum);

            Properties.Settings ustawienia = new Properties.Settings();
            this.Left = ustawienia.Left;
            this.Top = ustawienia.Top;
            this.Width = ustawienia.Width;
            this.Height = ustawienia.Height;
            this.radioButton1.Checked = ustawienia.radio1;
            this.radioButton2.Checked = ustawienia.radio2;
            if (radioButton1.Checked)
            {
                trackBar1.Value = ustawienia.R;
                trackBar2.Value = ustawienia.G;
                trackBar3.Value = ustawienia.B;
                trackBar1.Maximum = ustawienia.RGBMax;
                trackBar2.Maximum = ustawienia.RGBMax;
                trackBar3.Maximum = ustawienia.RGBMax ;
            }
            else
            {
                trackBar1.Maximum = ustawienia.HMax;
                trackBar2.Maximum = 100;
                trackBar3.Maximum = 100;
                trackBar1.Value = ustawienia.H;
                trackBar2.Value = ustawienia.S;
                trackBar3.Value = ustawienia.V;
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {            
            //e.Cancel = true;
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            Properties.Settings ustawienia = new Properties.Settings();
            ustawienia.Left = this.Left;
            ustawienia.Top = this.Top;
            ustawienia.Width = this.Width;
            ustawienia.Height = this.Height;
            ustawienia.R = (byte)trackBar1.Value;
            ustawienia.G = (byte)trackBar2.Value;
            ustawienia.B = (byte)trackBar3.Value;
            ustawienia.H = trackBar1.Value;
            ustawienia.S = trackBar2.Value;
            ustawienia.V = trackBar3.Value;
            ustawienia.radio1 = radioButton1.Checked;
            ustawienia.radio2 = radioButton2.Checked;
            ustawienia.HMax = 360;
            ustawienia.SLMax = 100;
            ustawienia.SLMax = 100;
            ustawienia.RGBMax = 255;
            ustawienia.RGBMax = 255;
            ustawienia.RGBMax = 255;
            ustawienia.Save();

            for (; this.Opacity > 0.0; this.Opacity -= 0.005) System.Threading.Thread.Sleep(1);
        }

        private void trackBar4_Scroll(object sender, EventArgs e)
        {
            TrackBar tb = sender as TrackBar;
            this.Opacity = tb.Value / (double)tb.Maximum;
        }

        private void Form1_KeyPress(object sender, KeyPressEventArgs e)
        {
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Control && e.KeyCode == Keys.C)
            {
                Clipboard.SetText("#" + trackBar1.Value.ToString("X2") + trackBar2.Value.ToString("X2") + trackBar3.Value.ToString("X2"));
            }
        }

        private void panel1_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = panel1.BackColor;
            DialogResult dr = colorDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                panel1.BackColor = colorDialog1.Color;
                czyAktualizowaćKolorPanelu = false;
                trackBar1.Value = panel1.BackColor.R;
                trackBar2.Value = panel1.BackColor.G;
                trackBar3.Value = panel1.BackColor.B;
                czyAktualizowaćKolorPanelu = true;
            }
        }

        private void panel1_MouseEnter(object sender, EventArgs e)
        {
            label8.Visible = true;
        }

        private void panel1_MouseLeave(object sender, EventArgs e)
        {
            label8.Visible = false;
        }

       
        public static Color ColorFromHSV(double hue, double saturation, double value)
        {
            int hi = Convert.ToInt32(Math.Floor(hue / 60)) % 6;
            double f = hue / 60 - Math.Floor(hue / 60);

            value = value * 255;
            int a = Convert.ToInt32(value);
            int b = Convert.ToInt32(value * (1 - saturation));
            int c = Convert.ToInt32(value * (1 - f * saturation));
            int d = Convert.ToInt32(value * (1 - (1 - f) * saturation));
            if (hi == 0)
                return Color.FromArgb(a, d, b);
            else if (hi == 1)
                return Color.FromArgb(c, a, b);
            else if (hi == 2)
                return Color.FromArgb(b, a, d);
            else if (hi == 3)
                return Color.FromArgb(b, c, a);
            else if (hi == 4)
                return Color.FromArgb(d, b, a);
            else
                return Color.FromArgb(a, b, c);
        }

        private void radioButton1_Click(object sender, EventArgs e)
        {
            label1.Text = "R";
            label2.Text = "G";
            label3.Text = "B";
            label1.ForeColor = Color.Red;
            label2.ForeColor = Color.Green;
            label3.ForeColor = Color.Blue;
            trackBar1.Maximum = 255;
            label5.Text = trackBar1.Value.ToString();
            trackBar2.Maximum = 255;
            label6.Text = trackBar2.Value.ToString();
            trackBar3.Maximum = 255;
            label7.Text = trackBar3.Value.ToString();
            pictureBox1.Visible = false;
        }

        private void radioButton2_Click(object sender, EventArgs e)
        {
            label1.Text = "H";
            label2.Text = "S";
            label3.Text = "V";
            label1.ForeColor = Color.Black;
            label2.ForeColor = Color.Black;
            label3.ForeColor = Color.Black;
            trackBar1.Maximum = 360;
            pictureBox1.Visible = true;
            label5.Text = trackBar1.Value.ToString();
            trackBar2.Maximum = 100;
            trackBar3.Maximum = 100;
        }

        private void pictureBox1_Click(object sender, EventArgs e)
        {
        
        }

        private void trackBar1_Scroll(object sender, EventArgs e)
        {
        
        }

        private void trackBar2_Scroll(object sender, EventArgs e)
        {
        
        }

        private void trackBar3_Scroll(object sender, EventArgs e)
        {
        
        }

        private void label5_Click(object sender, EventArgs e)
        {
        
        }

        private void label6_Click(object sender, EventArgs e)
        {
        
        }

        private void label7_Click(object sender, EventArgs e)
        {
        
        }

        private void label1_Click(object sender, EventArgs e)
        {
        
        }

        private void label2_Click(object sender, EventArgs e)
        {
        
        }

        private void label3_Click(object sender, EventArgs e)
        {
        
        }

        private void label4_Click(object sender, EventArgs e)
        {
        
        }

        private void panel1_Paint(object sender, PaintEventArgs e)
        {
        
        }

        private void Form1_MouseEnter(object sender, EventArgs e)
        {
        //for (; this.Opacity < 1; this.Opacity += 0.000005) ;
        }

        private void Form1_MouseLeave(object sender, EventArgs e)
        {
        // for (; this.Opacity > .50; this.Opacity -= 0.000005) ;
        }

        private void label8_Click(object sender, EventArgs e)
        {

        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {

        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)
        {

        }
    }

}
