﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace BlackBodyColor
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            Text = "Kolor ciała doskonale czarnego";
            Paint += Form1_Paint;
            Resize += Form1_Resize;

            SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            SetStyle(ControlStyles.UserPaint, true);
            SetStyle(ControlStyles.AllPaintingInWmPaint, true);
            Form1_Resize(null, null);
        }

        //
        //http://www.tannerhelland.com/4435/convert-temperature-rgb-algorithm-code/
        //
        Color TemperatureToColor(double temperature)
        {
            double r, g, b;
            temperature /= 100;

            if (temperature <= 66)
                r = 255;
            else
            {
                r = temperature - 60;
                r = 329.698727446 * Math.Pow(r, -0.1332047592);

                if (r < 0)
                    r = 0;

                if (r > 255)
                    r = 255;
            }

            if (temperature <= 66)
            {
                g = temperature;
                g = 99.4708025861 * Math.Log(g) - 161.1195681661;

                if (g < 0)
                    g = 0;

                if (g > 255)
                    g = 255;
            }
            else
            {
                g = temperature - 60;
                g = 288.1221695283 * Math.Pow(g, -0.0755148492);

                if (g < 0)
                    g = 0;

                if (g > 255)
                    g = 255;
            }

            if (temperature >= 66)
                b = 255;
            else
            {
                if (temperature <= 19)
                    b = 0;
                else
                {
                    b = temperature - 10;
                    b = 138.5177312231 * Math.Log(b) - 305.0447927307;

                    if (b < 0)
                        b = 0;

                    if (b > 255)
                        b = 255;
                }
            }

            return Color.FromArgb((int)r, (int)g, (int)b);
        }

        void Form1_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;

            for (int x = 0; x < ClientRectangle.Width; x++)
                g.DrawLine(new Pen(TemperatureToColor(1000 + (double)x / ClientRectangle.Width * 10000)), new Point(x, 0), new Point(x, ClientRectangle.Height));

            float labelWidth = g.MeasureString("10000", statusStrip1.Font).Width;
            int tickFrequency = 100;

            while ((9000.0 / tickFrequency) * labelWidth > statusStrip1.Width || 9000 % tickFrequency != 0)
                tickFrequency += 1;

            statusStrip1.Items.Clear();

            for (int i = 1000; i <= 10000; i += tickFrequency)
            {
                ToolStripStatusLabel label = new ToolStripStatusLabel(i.ToString());
                label.Spring = true;

                statusStrip1.Items.Add(label);
            }
        }

        void Form1_Resize(object sender, EventArgs e)
        {
            Invalidate();
        }
    }
}