﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace CialoDoskonaleCzarne
{
    public partial class Form1 : Form
    {
        static Color[] kolory_fal = new Color[401];

        double hc2 = 5.955214 * Math.Pow(10, -17);
        double hc = 1.986446 * Math.Pow(10, -25);
        double k = 1.38065 * Math.Pow(10, -23);


        public Form1()
        {
            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            this.SetStyle(ControlStyles.UserPaint, true);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);

            InitializeComponent();
            wypelnijTabliceKolorow();
        }

        private static void wypelnijTabliceKolorow()
        {
            double Red, Green, Blue;
            for (int Wavelength = 380; Wavelength <= 780; ++Wavelength) 
            {
                if (Wavelength >= 380 && Wavelength < 440)
                {
                    Red = -(Wavelength - 440) / (440 - 380);
                    Green = 0.0;
                    Blue = 1.0;
                }
                else
                    if (Wavelength >= 440 && Wavelength < 490)
                    {
                        Red = 0.0;
                        Green = (Wavelength - 440) / (490 - 440);
                        Blue = 1.0;
                    }
                    else
                        if (Wavelength >= 490 && Wavelength < 510)
                        {
                            Red = 0.0;
                            Green = 1.0;
                            Blue = -(Wavelength - 510) / (510 - 490);
                        }
                        else
                            if (Wavelength >= 510 && Wavelength < 580)
                            {
                                Red = (Wavelength - 510) / (580 - 510);
                                Green = 1.0;
                                Blue = 0.0;
                            }
                            else
                                if (Wavelength >= 580 && Wavelength < 645)
                                {
                                    Red = 1.0;
                                    Green = -(Wavelength - 645) / (645 - 580);
                                    Blue = 0.0;
                                }
                                else
                                    if (Wavelength >= 645 && Wavelength <= 780)
                                    {
                                        Red = 1.0;
                                        Green = 0.0;
                                        Blue = 0.0;
                                    }
                                    else
                                    {
                                        Red = 0.0;
                                        Green = 0.0;
                                        Blue = 0.0;
                                    }
                int R = Convert.ToInt16(Math.Round(Red * 255));
                int G = Convert.ToInt16(Math.Round(Green * 255));
                int B = Convert.ToInt16(Math.Round(Blue * 255));

                kolory_fal[Wavelength - 380] = Color.FromArgb(R, G, B);
            }
        }


        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {
            label1.Text = Convert.ToString(trackBar1.Value) + " K";
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            Properties.Settings ustawienia = new Properties.Settings();
            trackBar1.Value = ustawienia.temperatura;
            trackBar1_ValueChanged(sender, e);
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            Properties.Settings ustawienia = new Properties.Settings();
            ustawienia.temperatura = trackBar1.Value;
            ustawienia.Save();
        }


        private double u(int lambda,int t)
        {
            return 2 * hc2 / (Math.Pow(lambda/1000000000.0, 5) * (Math.Pow(Math.E, hc / (k * (lambda/1000000000.0) * t)) - 1));
        }

        private Color kolorCDC(int t)
        {
            double[] U = new double[401];
            double sU=0.0;
            for(int l=380;l<780;l++)
            {
                double ul = u(l+1, t);
                if(l>379 && l<779)
                {
                    U[l-380] = ul;
                }
                sU += ul;
            }
            double R = 0.0;
            double G = 0.0;
            double B = 0.0;
            
            for (int i = 0; i < 401; ++i)
            {
                R += (U[i] / sU) * kolory_fal[i].R;
                G += (U[i] / sU) * kolory_fal[i].G;
                B += (U[i] / sU) * kolory_fal[i].B;
            }

            return Color.FromArgb(Convert.ToInt16(Math.Round(R)), Convert.ToInt16(Math.Round(G)), Convert.ToInt16(Math.Round(B)));
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            int t=0;
            Graphics g = e.Graphics;
            for(int ix=0;ix<this.ClientSize.Width;++ix)
            {
                t = Convert.ToInt16(Math.Round((9000.0 * ix) / this.ClientSize.Width) + 1000);
                g.DrawLine(new Pen(kolorCDC(t)),new Point(ix,0),new Point(ix,this.ClientSize.Height));
            }
        }

        private void Form1_ResizeEnd(object sender, EventArgs e)
        {
            Refresh();
        }
    }
}
