﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Windows.Data;
using System.Windows.Media;

namespace KoloryWPF
{
    static class Rozszerzenia
    {
        public static Color ToColor(this Model.Kolor kolor)
        {
            return Color.FromRgb(kolor.R, kolor.G, kolor.B);
        }
    }

    public class KolorToSolidColorBrushConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            Model.Kolor kolor = (Model.Kolor)value;
            return new SolidColorBrush(kolor.ToColor());
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
