﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Thread = System.Threading.Thread;

namespace ElementyProgramowaniaWspolbieznego
{
    class Program
    {
        static private double obliczenia(double argument)
        {
            for (int i = 0; i < 10; ++i)
            {
                argument = Math.Asin(Math.Sin(argument));
            }
            return argument;
        }

        static void MainPętla(string[] args)
        {
            //przygotowania
            const int rozmiar = 10000;
            Random r = new Random();
            double[] tablica = new double[rozmiar];
            for (int i = 0; i < tablica.Length; ++i) tablica[i] = r.NextDouble();

            /*
            //t=5850ms
            //obliczenia sekwencyjne
            int liczbaPowtórzeń = 1000;
            double[] wyniki = new double[tablica.Length];
            int start = System.Environment.TickCount;
            for (int powtórzenia = 0; powtórzenia < liczbaPowtórzeń; ++powtórzenia)
                for (int i = 0; i < tablica.Length; ++i)
                    wyniki[i] = obliczenia(tablica[i]);
            int stop = System.Environment.TickCount;
            Console.WriteLine("Obliczenia sekwencyjne trwały " + (stop - start).ToString() + " ms");
            */

            //oblicze równoległe
            //t=1591ms
            int liczbaPowtórzeń = 1000;
            double[] wyniki = new double[tablica.Length];
            int start = System.Environment.TickCount;
            for (int powtórzenia = 0; powtórzenia < liczbaPowtórzeń; ++powtórzenia)
            {
                Parallel.For(0, tablica.Length, (int i) => { wyniki[i] = obliczenia(tablica[i]); });
            }                
            int stop = System.Environment.TickCount;
            Console.WriteLine("Obliczenia sekwencyjne trwały " + (stop - start).ToString() + " ms");
        }

        static void MainZadanie(string[] args)
        {
            //czynność
            Func<object, long> akcja = (object argument) =>
                {
                    Console.WriteLine("Początek działania akcji (" + Thread.CurrentThread.ManagedThreadId + ") - " + argument.ToString());
                    Thread.Sleep(500); //0.5s
                    Console.WriteLine("Koniec działania akcji (" + Thread.CurrentThread.ManagedThreadId + ") - " + argument.ToString());
                    return DateTime.Now.Ticks;
                };

            //synchronicznie
            //long wynik = akcja("synchronicznie");
            //Console.WriteLine("Synchronicznie: " + wynik.ToString());

            //w osobnym zadaniu
            Task<long> zadanie = new Task<long>(akcja, "zadanie");
            zadanie.Start();
            Console.WriteLine("Akcja została uruchomiona (" + Thread.CurrentThread.ManagedThreadId + ")");
            long wynik = zadanie.Result; //synchronizacja
            Console.WriteLine("Zadanie (" + Thread.CurrentThread.ManagedThreadId + ") - " + wynik.ToString());
        }

        //Typowa metoda asynchroniczna = tworząca i uruchamiająca zadanie
        static Task<long> ZrobCosAsync(object argument)
        {
            //czynność
            Func<object, long> akcja = (object _argument) =>
            {
                Console.WriteLine("Początek działania akcji (" + Thread.CurrentThread.ManagedThreadId + ") - " + _argument.ToString());
                Thread.Sleep(500); //0.5s
                Console.WriteLine("Koniec działania akcji (" + Thread.CurrentThread.ManagedThreadId + ") - " + _argument.ToString());
                return DateTime.Now.Ticks;
            };

            //w osobnym zadaniu
            Task<long> zadanie = new Task<long>(akcja, "zadanie");
            zadanie.Start();
            return zadanie;
        }

        static void MainZadanieMetoda(string[] args)
        {
            Task<long> zadanie = ZrobCosAsync("zadanie-metoda asynchroniczna");
            Console.WriteLine("Akcja została uruchomiona (" + Thread.CurrentThread.ManagedThreadId + ")");
            long wynik = zadanie.Result; //synchronizacja
            Console.WriteLine("Zadanie (" + Thread.CurrentThread.ManagedThreadId + ") - " + wynik.ToString());
        }

        static async void AsyncMain(string[] args)
        {
            Task<long> zadanie = ZrobCosAsync("zadanie-metoda asynchroniczna");
            Console.WriteLine("Akcja została uruchomiona (" + Thread.CurrentThread.ManagedThreadId + ")");
            long wynik = await zadanie; //synchronizacja
            Console.WriteLine("Zadanie (" + Thread.CurrentThread.ManagedThreadId + ") - " + wynik.ToString());
        }

        //Metoda async
        static void Main(string[] args)
        {
            Console.WriteLine("Main - początek");
            //MainZadanie(args);
            AsyncMain(args);            
            Console.WriteLine("Main - koniec");

            Console.WriteLine("Naciśnij ENTER..."); Console.ReadLine();
        }
    }
}
