﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LINQ
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        class Osoba
        {
            public int Id;
            public string Imię;
            public string Nazwisko;
            public int Wiek;
            public int NumerTelefonu;

            public override string ToString()
            {
                return this.Imię + " " + this.Nazwisko + " (" + this.Wiek + ")";
            }
        }

        List<Osoba> listaOsób = new List<Osoba>()
        {
            new Osoba() { Id = 0, Imię = "Jacek", Nazwisko = "Matulewski", Wiek = 42, NumerTelefonu = 1234567890 },
            new Osoba() { Id = 1, Imię = "Dominika", Nazwisko = "Różycka", Wiek = 22, NumerTelefonu = 0000000000 },
            new Osoba() { Id = 2, Imię = "Paulina", Nazwisko = "Gajda", Wiek = 20, NumerTelefonu = 111111111 },
            new Osoba() { Id = 3, Imię = "Roman", Nazwisko = "Gardziński", Wiek = 21, NumerTelefonu = 2222222 }
        };

        private void button1_Click(object sender, EventArgs e)
        {
            var zapytanie1 = from o in listaOsób /*.AsParallel()*/
                             where o.Wiek >= 18
                             where o.Imię.EndsWith("a")
                             orderby o.Wiek descending                             
                             select o.Imię + " " + o.Nazwisko;

            var zapytanie2 = 
                listaOsób
                .Where(o => (o.Wiek >= 18))
                .Where(o => o.Imię.EndsWith("a"))
                .OrderBy(o => o.Wiek)
                .Select(o => o.Imię + " " + o.Nazwisko);

            //zmiana w źródle danych
            listaOsób[0].Imię = "Bartek";
            listaOsób[0].Wiek = 9;

            //lista osób niepełnoletnich nie będących kobietami
            var zapytanie3 = from o in listaOsób
                             where o.Wiek < 18 && !o.Imię.EndsWith("a")
                             select o;
                             //select new Osoba() { Imię = o.Imię, Nazwisko = o.Nazwisko, Wiek = o.Wiek, NumerTelefonu = o.NumerTelefonu };
                             //select new { Imię = o.Imię, Nazwisko = o.Nazwisko, Wiek = o.Wiek };

            zapytanie3.First().Wiek = 10;

            var personalia = from o in listaOsób
                             select new { o.Id, o.Imię, o.Nazwisko };
            var numeryTelefonów = from o in listaOsób
                                  select new { o.Id, o.NumerTelefonu };

            var zapytanie4 = from o in personalia
                             join p in numeryTelefonów
                             on o.Id equals p.Id
                             select new Osoba() { Id = o.Id, Imię = o.Imię, Nazwisko = o.Nazwisko, NumerTelefonu = p.NumerTelefonu };

            //Concat, Distinct

            string s = "";
            foreach(var element in zapytanie4)
            {
                s += element.ToString() + "\n";
            }
            MessageBox.Show(s);
        }

        int kwadrat1(int x)
        {
            return x * x;
        }

        delegate int Kwadrat2Typ(int x);
        Kwadrat2Typ kwadrat2;

        private void button2_Click(object sender, EventArgs e)
        {
            int y = kwadrat1(1);
            MessageBox.Show(y.ToString());

            kwadrat2 = kwadrat1;
            y = kwadrat2(2);
            MessageBox.Show(y.ToString());

            Func<int,int> kwadrat3 = kwadrat1;
            y = kwadrat3(3);
            MessageBox.Show(y.ToString());

            Func<int, int> kwadrat4 = (int x) => { return x * x; };
            y = kwadrat4(4);
            MessageBox.Show(y.ToString());

            Func<int, int> kwadrat5 = x => x * x;
            y = kwadrat5(5);
            MessageBox.Show(y.ToString());

            Action<int> pokaż = x => MessageBox.Show(x.ToString());
            pokaż(y);
        }
    }
}
