﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace KolorowyPasekPostępuDemo
{
    public partial class KolorowyPasekPostępu : UserControl
    {
        public KolorowyPasekPostępu()
        {
            this.DoubleBuffered = true;
            InitializeComponent();
        }

        private void KolorowyPasekPostępu_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;

            Pen cien = new Pen(SystemColors.ControlDark);
            Pen swiatlo = new Pen(SystemColors.ControlLightLight);
            g.DrawLine(cien, 0, Height - 1, 0, 0);
            g.DrawLine(cien, 0, 0, Width - 1, 0);
            g.DrawLine(swiatlo, Width - 1, 0, Width - 1, Height - 1);
            g.DrawLine(swiatlo, Width - 1, Height - 1, 0, Height - 1);

            
            double procent = (Value - Minimum) / (double)(Maximum - Minimum);
            const int margines = 2;
            int szerokosc = (int)(procent * Width - 2 * margines);
            
            Brush pedzelPaska = new SolidBrush(SystemColors.ActiveCaption);
            //g.FillRectangle(pędzelPaska, margines, margines, Width - 1 - 2 * margines, Height - 1 - 2 * margines);            
            //g.FillRectangle(pedzelPaska, margines, margines, szerokosc, Height - 1 - 2 * margines);
            for(int ix=margines;ix<szerokosc;++ix)
            {
                Pen pioroPaska = new Pen(ColorBegin.Lerp(ix / (float)(Width - 2 * margines), ColorEnd));
                g.DrawLine(pioroPaska, ix, margines, ix, Height - 1 - margines);
            }
        }

        #region Pola i własności
        private int minimum = 0;
        private int maximum = 100;
        private int value = 0;

        [
            Category("Behavior"),
            Description("Dolna granica wartości")
        ]
        public int Minimum
        {
            get
            {
                return minimum;
            }
            set
            {
                if (value > maximum) value = maximum;
                minimum = value;
                Refresh();
            }
        }

        [
            Category("Behavior"),
            Description("Górna granica wartości")
        ]
        public int Maximum
        {
            get
            {
                return maximum;
            }
            set
            {
                if (value < minimum) value = minimum;
                maximum = value;
                Refresh();
            }
        }

        [
            Category("Behavior"),
            Description("Wartość")
        ]
        public int Value
        {
            get
            {
                return value;
            }
            set
            {
                if (value < minimum) value = minimum;
                if (value > maximum) value = maximum;
                this.value = value;
                OnValueChanged();
                Refresh();
            }
        }

        private Color colorBegin = Color.Red;
        private Color colorEnd = Color.Yellow;

        public Color ColorBegin 
        { 
            get
            {
                return colorBegin;
            }
            set
            {
                colorBegin = value;
                Refresh();
            }
        }

        public Color ColorEnd
        {
            get
            {
                return colorEnd;
            }
            set
            {
                colorEnd = value;
                Refresh();
            }
        }
        #endregion

        #region Zdarzenia
        public delegate void ValueChangedEventHandler(object sender, EventArgs e);
        public event ValueChangedEventHandler ValueChanged;

        private void OnValueChanged()
        {
            if (ValueChanged != null) ValueChanged(this, new EventArgs());
        }
        #endregion
    }

    static class Rozszerzenia
    {
        static int Lerp(float waga, int wartość1, int wartość2)
        {
            return (int)((1 - waga) * wartość1 + waga * wartość2);
        }

        public static Color Lerp(float waga, Color kolor1, Color kolor2)
        {
            int R = Lerp(waga, kolor1.R, kolor2.R);
            int G = Lerp(waga, kolor1.G, kolor2.G);
            int B = Lerp(waga, kolor1.B, kolor2.B);
            return Color.FromArgb(R, G, B);
        }

        public static Color Lerp(this Color kolor1, float waga, Color kolor2)
        {
            return Rozszerzenia.Lerp(waga, kolor1, kolor2);
        }

        public static int ObliczPole(this System.Drawing.Rectangle r)
        {
            return r.Width * r.Height;
        }
    }
}
