﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.IO;

namespace Notatnik
{
    public partial class Form1 : Form
    {
        string ścieżkaPliku = null;

        public Form1()
        {
            InitializeComponent();

            saveFileDialog1.Filter = openFileDialog1.Filter;
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        //rozszezenie do textbox

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (ścieżkaPliku != null) openFileDialog1.FileName = ścieżkaPliku;
            DialogResult dr = openFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                string[] wiersze;
                if (PlikiTekstowe.CzytajPlikTekstowy(openFileDialog1.FileName, out wiersze))
                {
                    ścieżkaPliku = openFileDialog1.FileName;
                    textBox1.Lines = wiersze;
                    toolStripStatusLabel1.Text = "Wczytano plik " + ścieżkaPliku;
                    statusStrip1.BackColor = Color.Green;
                    textBox1.ReadOnly = openFileDialog1.ReadOnlyChecked;
                }
                else
                {
                    toolStripStatusLabel1.Text = "Nie powiodło się wczytanie pliku " + ścieżkaPliku;
                    statusStrip1.BackColor = Color.Red;                    
                }
            }
        }

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (ścieżkaPliku != null) PlikiTekstowe.ZapiszDoPlikuTekstowego(ścieżkaPliku, textBox1.Lines);
            else zapiszJakoToolStripMenuItem_Click(sender, e);            
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (ścieżkaPliku != null)
            {
                saveFileDialog1.InitialDirectory = Path.GetDirectoryName(ścieżkaPliku);
                saveFileDialog1.FileName = Path.GetFileName(ścieżkaPliku);
            }
            DialogResult dr = saveFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                if (PlikiTekstowe.ZapiszDoPlikuTekstowego(saveFileDialog1.FileName, textBox1.Lines))
                {
                    ścieżkaPliku = saveFileDialog1.FileName;
                    toolStripStatusLabel1.Text = "Tekst zapisany do pliku " + ścieżkaPliku;
                    statusStrip1.BackColor = Color.Green;
                }
                else
                {
                    toolStripStatusLabel1.Text = "Nie powiodła się próba zapisu do pliku " + ścieżkaPliku;
                    statusStrip1.BackColor = Color.Red;
                }
            }
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (textBox1.Text == "") return;

            DialogResult dr = MessageBox.Show(
                "Czy chcesz zapisać zmiany w pliku?", 
                this.Text, 
                MessageBoxButtons.YesNoCancel, 
                MessageBoxIcon.Question, 
                MessageBoxDefaultButton.Button3);

            switch (dr)
            {
                case DialogResult.Yes:
                    zapiszJakoToolStripMenuItem_Click(sender, e);                    
                    //konkurs - jak zrobić elegancko (bez dodawania flagi i DRY)
                    break;
                case DialogResult.No:
                    break;
                case DialogResult.Cancel:
                    return;
            }
            textBox1.Text = "";
        }
    }
}
