﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Płótno
{
    public partial class Form1 : Form
    {
        Color kolor1 = Color.Green;
        Color kolor2 = Color.Blue;

        public Form1()
        {
            //ustawienia pozwalające uniknąć mrugania obszarów
            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            this.SetStyle(ControlStyles.UserPaint, true);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);

            InitializeComponent();
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;

            for (int iy = 0; iy < this.ClientSize.Height; ++iy)
            {
                float waga = iy / (float)this.ClientSize.Height;
                //Color kolor = Rozszerzenia.Lerp(waga, kolor1, kolor2);
                Color kolor = kolor1.Lerp(waga, kolor2);
                g.DrawLine(new Pen(kolor), new Point(0, iy), new Point(this.ClientSize.Width, iy));                       
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {            
            //this.Refresh();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = kolor1;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                kolor1 = colorDialog1.Color;
                Refresh();
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = kolor2;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                kolor2 = colorDialog1.Color;
                Refresh();
            }
        }
    }

    static class Rozszerzenia
    {
        static int Lerp(float waga, int wartość1, int wartość2)
        {
            return (int)((1 - waga) * wartość1 + waga * wartość2);
        }

        public static Color Lerp(float waga, Color kolor1, Color kolor2)
        {
            int R = Lerp(waga, kolor1.R, kolor2.R);
            int G = Lerp(waga, kolor1.G, kolor2.G);
            int B = Lerp(waga, kolor1.B, kolor2.B);
            return Color.FromArgb(R, G, B);
        }

        public static Color Lerp(this Color kolor1, float waga, Color kolor2)
        {
            return Rozszerzenia.Lerp(waga, kolor1, kolor2);
        }

        public static int ObliczPole(this System.Drawing.Rectangle r)
        {
            return r.Width * r.Height;
        }
    }
}
