﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Net.NetworkInformation;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Send_ICMP
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

          public void WyslijPing(string adres,int czasOczekiwania,
            byte[] bufor,PingOptions opcjePing)
        {
            Ping ping = new Ping();
            ping.PingCompleted += new PingCompletedEventHandler(koniecPinga);
            try
            {
                ping.SendAsync(adres, czasOczekiwania, bufor, opcjePing, null);

            }
            catch(Exception exc)
            {
                listBox1.Items.Add("Błąd: " + adres + " " + exc.Message);

            }



        }

        public void koniecPinga(object sender,PingCompletedEventArgs e)
          {
            if(e.Cancelled||e.Error!=null)
            {
                listBox1.Items.Add("Wystąpił bład lub operacja przerwana przez użytkownika");
                ((IDisposable)(Ping)sender).Dispose();
                return;
            }

            PingReply odpowiedz = e.Reply;

            if (odpowiedz.Status == IPStatus.Success)
                listBox1.Items.Add("Odpowiedź z" + odpowiedz.Address.ToString() +
                    "bajtów= " + odpowiedz.Buffer.Length + " czas=" +
                    odpowiedz.RoundtripTime.ToString() + " ms" +
                    " TTL= " + odpowiedz.Options.Ttl.ToString());
            else
                listBox1.Items.Add("Bład brak odpowiedzi z " + e.Reply.Address +
                    ": " + odpowiedz.Status);

            ((IDisposable)(Ping)sender).Dispose();

          }

        private void button1_Click(object sender, EventArgs e)
        {
            int wlkBufora = 32;
            string txt_bufor=String.Empty;
            PingOptions opcjePing = new PingOptions();
            byte[] pakiet;

            try
            {
                wlkBufora = Convert.ToInt32(bufor.Text);

            }
            catch
            {
                bufor.Text = "32";
                wlkBufora = 32;

            }

            for(int i=0;i<wlkBufora;i++)
            {
                txt_bufor += "a";
            }

            opcjePing.Ttl = 32;
            opcjePing.DontFragment = true;

            pakiet = Encoding.ASCII.GetBytes(txt_bufor);

            WyslijPing(textBox_adres.Text, Convert.ToInt32(TimeOut.Value), pakiet, opcjePing);



        }

    }
}
