﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using BingMaps.GeoCodeService;

namespace BingMaps
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private string GetLocationFromAddress(string address)
        {
            string geoCodeKey = "AuMw_HKo87NfyMR_CDm_h8vYVAYFkY78BQy0cPn5hGqAgFkleGJCcK7-hr2WXZGo";
            string results = "";

            GeocodeRequest geoCodeRequest = new GeocodeRequest();

            //ustawienie poświadczeń
            geoCodeRequest.Credentials = new Credentials();
            geoCodeRequest.Credentials.ApplicationId = geoCodeKey;

            //przekazanie adresu
            geoCodeRequest.Query = address;

            //ustawianie sposobu przekazywania odpowiedzi
            ConfidenceFilter[] filters = new ConfidenceFilter[1];
            filters[0] = new ConfidenceFilter();
            filters[0].MinimumConfidence = Confidence.High;
            GeocodeOptions geoCodeOptions = new GeocodeOptions();
            geoCodeOptions.Filters = filters;
            geoCodeRequest.Options = geoCodeOptions;

            //obiekt reprezentujący usługę
            GeocodeService geoCodeService = new GeocodeService();
            GeocodeResponse geoCodeResponse = geoCodeService.Geocode(geoCodeRequest);

            if (geoCodeResponse.Results == null || geoCodeResponse.Results.Length == 0)
                return "Błąd usługi";
            else
                results = String.Format(address + " => długość: {0}, szerokość: {1}", geoCodeResponse.Results[0].Locations[0].Latitude, geoCodeResponse.Results[0].Locations[0].Longitude);

            return results;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if(textBox1.Text != null && textBox1.Text.Trim().Length>0)
                listBox1.Items.Add(GetLocationFromAddress(textBox1.Text));
        }
    }
}
