﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Http;

namespace Remoting
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private void Button_Click_1(object sender, RoutedEventArgs e)
        {
            string adres = Adres.Text;
            if (!adres.StartsWith("http://")) adres = "http://" + adres;
            int port = int.Parse(Port.Text);
            HttpClientChannel channel = null;
            try
            {
                channel = new HttpClientChannel();
                ChannelServices.RegisterChannel(channel, false);
                RemotingObject ro = (RemotingObject)Activator.GetObject(typeof(RemotingObject), adres + ":" + port + "/Remoting");
                listBox.Items.Add(ro.Test());
                ChannelServices.UnregisterChannel(channel);
                listBox.Items.Add("Połączenie zakończone");
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
                listBox.Items.Add("Połączenie zerwane");
                ChannelServices.UnregisterChannel(channel);
            }
        }
    }
}
