﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;

namespace RemotingTcp
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private TcpClientChannel channel;
        private RemotingMath remotingMath;

        public MainWindow()
        {
            InitializeComponent();
        }

        private void Grid_Loaded_1(object sender, RoutedEventArgs e)
        {
            channel = new TcpClientChannel();
            ChannelServices.RegisterChannel(channel, false);
            WellKnownClientTypeEntry config = new WellKnownClientTypeEntry(typeof(RemotingMath), "tcp://localhost:25001/Math");
            RemotingConfiguration.RegisterWellKnownClientType(config);
            remotingMath = new RemotingMath();
        }

        private void Button_Click_1(object sender, RoutedEventArgs e)
        {
            if (String.IsNullOrEmpty(A.Text) && String.IsNullOrEmpty(B.Text))
            {
                MessageBox.Show("Uzupełnij pola");
                return;
            }

            try
            {
                double a = double.Parse(A.Text);
                double b = double.Parse(B.Text);
                Wynik.Text = remotingMath.Add(a, b).ToString();
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
                ChannelServices.UnregisterChannel(channel);
            }
            
        }
    }
}
