﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Net;
using System.Net.Sockets;
using System.IO;

namespace ZdalnyZrzutEkranuSerwer
{
    public partial class Form1 : Form
    {
        private int portSerweraKomend = 1978;
        private int portSerweraDanych = 43210;

        private Image obraz = null;

        public Form1()
        {
            InitializeComponent();
            backgroundWorker2.RunWorkerAsync();            
        }

        private void zapiszZrzutEkranuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    Bitmap obrazDoZapisania = new Bitmap(this.obraz);
                    obrazDoZapisania.Save(saveFileDialog1.FileName);
                }
                catch
                {
                    MessageBox.Show("Nie można zapisać pliku: " + saveFileDialog1.FileName, "Błąd", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        delegate void AddTextCallback(string wiadomość);
        private void addText(string wiadomość)
        {
            if (listBox1.InvokeRequired)
            {
                AddTextCallback f = new AddTextCallback(addText);
                this.Invoke(f, new object[] { wiadomość });
            }
            else
            {
                this.listBox1.Items.Add(wiadomość);
            }
        }

        delegate void RemoveTextCallback(int indeks);
        private void removeText(int indeks)
        {
            if (listBox1.InvokeRequired)
            {
                RemoveTextCallback f = new RemoveTextCallback(removeText);
                this.Invoke(f, new object[] { indeks });
            }
            else
            {
                this.listBox1.Items.RemoveAt(indeks);
            }
        }

        private void backgroundWorker2_DoWork(object sender, DoWorkEventArgs e)
        {
            IPEndPoint zdalnyAdresIP = new IPEndPoint(IPAddress.Any, 0);
            UdpClient klient = new UdpClient(portSerweraDanych);
            while (true)
            {
                byte[] bufor = klient.Receive(ref zdalnyAdresIP);
                string dane = Encoding.ASCII.GetString(bufor);
                string[] komenda = dane.Split(new char[] { ':' });

                if (komenda[1] == "HI")
                {
                    foreach (string wpis in listBox1.Items)
                    {
                        if (wpis == komenda[0])
                        {
                            MessageBox.Show("Próba nawiązania połączenia z " + komenda[0] + " została odrzucona, ten klient jest już podłączony.");
                            return;
                        }                        
                    }
                    addText(komenda[0]);
                }

                if (komenda[1] == "BYE")
                {
                    for (int i = 0; i < listBox1.Items.Count; i++)
                    {
                        if (listBox1.Items[i].ToString() == komenda[0]) this.removeText(i);
                    }
                }
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex < 0)
            {
                MessageBox.Show("Zaznacz klienta");
                return;
            }

            try
            {
                TcpClient klient = new TcpClient(listBox1.SelectedItem.ToString(), portSerweraKomend);
                NetworkStream ns = klient.GetStream();
                byte[] bufor = new byte[5];
                bufor = Encoding.ASCII.GetBytes("S");
                ns.Write(bufor, 0, bufor.Length);
                if (!backgroundWorker1.IsBusy) backgroundWorker1.RunWorkerAsync();
                else MessageBox.Show("Nie można teraz pobrać zrzutu ekranu z wybranego klienta, pobierany jest inny obraz");
            }
            catch
            {
                MessageBox.Show("Błąd: Nie można nawiązać połączenia");
            }
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            TcpListener serwer2 = new TcpListener(IPAddress.Parse(textBox1.Text),(int)numericUpDown1.Value);
            serwer2.Start();
            TcpClient klient2 = serwer2.AcceptTcpClient();
            NetworkStream ns = klient2.GetStream();
            byte[] bajtyObrazu;

            using (BinaryReader br = new BinaryReader(ns))
            {
                int rozmiarObrazu = br.ReadInt32();
                bajtyObrazu = br.ReadBytes(rozmiarObrazu);
            }

            using (MemoryStream ms = new MemoryStream(bajtyObrazu))
            {
                obraz = Image.FromStream(ms);
                pictureBox1.Image = obraz;
            }

            serwer2.Stop();
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}
