﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.IO;
using System.Drawing.Imaging;
using System.Net;
using System.Net.Sockets;

namespace ZdalnyZrzutEkranuKlient
{
    public partial class Form1 : Form
    {
        private int portSerweraKomend = 1978;
        private IPAddress adresIPSerweraDanych = IPAddress.Parse("127.0.0.1");
        private int portSerweraDanych = 43210;
        private int portSerweraDanychObrazu = 25000;
        private string lokalnyAdresIP = "127.0.0.1";
        private Bitmap obraz = null;

        public Form1()
        {            
            InitializeComponent();
            addText("Wstrzymuję uruchomienie na sekundę...");
            System.Threading.Thread.Sleep(1000);
            backgroundWorker1.RunWorkerAsync();
        }

        private Bitmap wykonajZrzutEkranu()
        {
            Bitmap obraz = new Bitmap(Screen.PrimaryScreen.Bounds.Width, Screen.PrimaryScreen.Bounds.Height, System.Drawing.Imaging.PixelFormat.Format32bppPArgb);
            Graphics zrzutEkranu = Graphics.FromImage(obraz);
            zrzutEkranu.CopyFromScreen(Screen.PrimaryScreen.Bounds.X, Screen.PrimaryScreen.Bounds.Y, 0, 0, Screen.PrimaryScreen.Bounds.Size, CopyPixelOperation.SourceCopy);
            return obraz;
        }

        delegate void AddTextCallback(string wiadomość);
        private void addText(string wiadomość)
        {
            if (listBox1.InvokeRequired)
            {
                AddTextCallback f = new AddTextCallback(addText);
                this.Invoke(f, new object[] { wiadomość });
            }
            else
            {
                this.listBox1.Items.Add(wiadomość);
            }
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            TcpListener serwer = new TcpListener(IPAddress.Parse(lokalnyAdresIP), portSerweraKomend);
            serwer.Start();
            this.addText("Oczekuję na komendy na porcie " + portSerweraKomend + "...");

            while (true)
            {
                TcpClient klientKomend = serwer.AcceptTcpClient();
                this.addText("Odebrano komendę");
                NetworkStream nsKomend = klientKomend.GetStream();
                byte[] bufor = new Byte[1];
                int odczyt = nsKomend.Read(bufor, 0, bufor.Length);
                //string s = Encoding.ASCII.GetString(bufor);
                string wiadomość = Encoding.ASCII.GetString(bufor);

                if (wiadomość == "S")
                {
                    this.addText("Zrzut ekranu jest wykonywany...");
                    obraz = wykonajZrzutEkranu();
                    MemoryStream ms = new MemoryStream();
                    obraz.Save(ms, ImageFormat.Jpeg);
                    byte[] bajtyObrazu = ms.GetBuffer();
                    ms.Close();

                    try
                    {
                        TcpClient klientDanych = new TcpClient(adresIPSerweraDanych.ToString(), portSerweraDanychObrazu);
                        NetworkStream nsDanych = klientDanych.GetStream();
                        this.addText("Przesyłanie zrzutu ekranu...");

                        using (BinaryWriter bw = new BinaryWriter(nsDanych))
                        {
                            bw.Write((int)bajtyObrazu.Length);
                            bw.Write(bajtyObrazu);
                        }
                        this.addText("Zrzut ekranu został przesłany.");
                    }
                    catch (Exception exc)
                    {
                        this.addText("Błąd podczas przesyłania zrzutu ekranu: " + exc.Message);
                    }
                }
            }
        }

        private void WyślijWiadomośćUDP(string wiadomość)
        {
            UdpClient klient = new UdpClient(adresIPSerweraDanych.ToString(), portSerweraDanych);
            byte[] bufor = Encoding.ASCII.GetBytes(wiadomość);
            klient.Send(bufor, bufor.Length);
            klient.Close();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            WyślijWiadomośćUDP(lokalnyAdresIP + ":HI");
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            WyślijWiadomośćUDP(lokalnyAdresIP + ":BYE");
        }
    }
}
