﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.IO;
using System.Net;
using System.Net.Sockets;

namespace KomunikatorKlient
{
    public partial class Form1 : Form
    {
        private TcpClient klient;
        private BinaryReader br = null;
        private BinaryWriter bw = null;
        private string adresIPSerwera = "127.0.0.1";
        private bool połączenieAktywne;

        private bool pogrubienie = false;
        private bool pochylenie = false;

        public Form1()
        {
            InitializeComponent();

            webBrowser1.Navigate("about:blank");
            webBrowser1.Document.Write(
                "<html><head><style>body, table{font-size:10pt; font-family: verdana; margin: 3px 3px 3px 3px; font-color: black;}</style></head><body width=\"" +
                (webBrowser1.ClientSize.Width - 20).ToString() + "\">");
            IPHostEntry adresyIP = Dns.GetHostEntry(Dns.GetHostName());
            foreach (IPAddress pozycja in adresyIP.AddressList) comboBox1.Items.Add(pozycja.ToString());
        }

#region Obsługa wątku UI
        delegate void SetTextCallBack(string tekst);
        delegate void SetScrollCallBack();

        private void SetText(string tekst)
        {
            if (listBox1.InvokeRequired)
            {
                SetTextCallBack f = new SetTextCallBack(SetText);
                this.Invoke(f, new object[] { tekst });
            }
            else
            {
                this.listBox1.Items.Add(tekst);
            }
        }

        private void SetTextHtml(string tekst)
        {
            if (webBrowser1.InvokeRequired)
            {
                SetTextCallBack f = new SetTextCallBack(SetTextHtml);
                this.Invoke(f, new object[] { tekst });
            }
            else
            {
                this.webBrowser1.Document.Write(tekst);
            }
        }

        private void SetScroll()
        {
            if (webBrowser1.InvokeRequired)
            {
                SetScrollCallBack f = new SetScrollCallBack(SetScroll);
                this.Invoke(f);
            }
            else
            {
                this.webBrowser1.Document.Window.ScrollTo(1, Int16.MaxValue);
            }
        }
#endregion

        private void WpiszTekst(string nadawca, string wiadomość)
        {
            SetTextHtml(
                "<table><tr><td width=\"10%\"><b>" + nadawca +
                "</b></td><td width=\"90%\">(" + DateTime.Now.ToShortDateString() +
                "):</td></tr>");
            SetTextHtml("<tr><td colspan=2>" + Formatuj(wiadomość) + "</td></tr></table>");
            SetTextHtml("<hr>");
            SetScroll();
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            try
            {
                klient = new TcpClient(adresIPSerwera, (int)numericUpDown1.Value);
                NetworkStream ns = klient.GetStream();
                br = new BinaryReader(ns);
                bw = new BinaryWriter(ns);
                bw.Write("HI");
                SetText("Autoryzacja...");
                połączenieAktywne = true;
                backgroundWorker2.RunWorkerAsync();
            }
            catch (Exception)
            {
                SetText("Nie można nawiązać połączenia z serwerem");
                połączenieAktywne = false;
            }
        }

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                using (StreamWriter sw = new StreamWriter(saveFileDialog1.FileName))
                {
                    try
                    {
                        sw.Write(webBrowser1.DocumentText);
                    }
                    catch
                    {
                        MessageBox.Show("Zapisanie pliku nie powiodło się");
                    }
                }
            }
        }

        private void czyśćToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //textBox1.Clear();
            webBrowser1.Navigate("about:blank");
            webBrowser1.Document.Write(
                "<html><head><style>body, table{font-size:10pt; font-family: verdana; margin: 3px 3px 3px 3px; font-color: black;}</style></head><body width=\"" +
                (webBrowser1.ClientSize.Width - 20).ToString() + "\">");
        }

        private void backgroundWorker2_DoWork(object sender, DoWorkEventArgs e)
        {
            SetText("Autoryzacja zakończona");
            string wiadomość;
            try
            {
                while ((wiadomość = br.ReadString()) != "BYE")
                {
                    WpiszTekst("ktoś", wiadomość);
                }
                SetText("Połączenie zakończone");
                połączenieAktywne = false;
                klient.Close();
            }
            catch (Exception)
            {
                SetText("Połączenie z serwerem zostało przerwane");
                połączenieAktywne = false;
                klient.Close();
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (!połączenieAktywne)
            {
                backgroundWorker1.RunWorkerAsync();
                webBrowser1.Navigate("about:blank");
                //button1.Text = "Rozłącz";
            }
            else
            {
                połączenieAktywne = false;
                if (klient != null)
                {
                    bw.Write("BYE");
                    klient.Close();
                    button1.Text = "Połącz";
                }
            }
        }

        private void PrzełączStanPrzycisku(Button button)
        {
            Color tmp = button.ForeColor;
            button.ForeColor = button.BackColor;
            button.BackColor = tmp;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            pogrubienie = !pogrubienie;
            PrzełączStanPrzycisku(button3);
        }

        private void button4_Click(object sender, EventArgs e)
        {
            pochylenie = !pochylenie;
            PrzełączStanPrzycisku(button4);
        }

        private string Formatuj(string tekst)
        {
            if (pogrubienie) tekst = "<b>" + tekst + "</b>";
            if (pochylenie) tekst = "<i>" + tekst + "</i>";
            return tekst;
        }

        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)13)
            {
                this.button2_Click(sender, e);
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            WpiszTekst("ja", textBox1.Text);
            if (połączenieAktywne) bw.Write(Formatuj(textBox1.Text));
            textBox1.Clear();
        }
    }
}
