﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.IO;
using System.Net;
using System.Net.Sockets;

namespace Komunikator
{
    public partial class Form1 : Form
    {
        private int? pozycjaKursora = null;

        private TcpListener serwer = null;
        private TcpClient klient = null;
        private string adresIP = "127.0.0.1";
        private BinaryReader br = null;
        private BinaryWriter bw = null;
        private bool połączenieAktywne = false;

        private bool pogrubienie = false;
        private bool pochylenie = false;

        public Form1()
        {
            InitializeComponent();

            webBrowser1.Navigate("about:blank");
            webBrowser1.Document.Write(
                "<html><head><style>body, table{font-size:10pt; font-family: verdana; margin: 3px 3px 3px 3px; font-color: black;}</style></head><body width=\"" +
                (webBrowser1.ClientSize.Width - 20).ToString() + "\">");
            IPHostEntry adresyIP = Dns.GetHostEntry(Dns.GetHostName());
            foreach (IPAddress pozycja in adresyIP.AddressList) comboBox1.Items.Add(pozycja.ToString());            
        }

        private void textBox1_MouseUp(object sender, MouseEventArgs e)
        {
            pozycjaKursora = textBox1.SelectionStart;
        }

        private void textBox1_KeyUp(object sender, KeyEventArgs e)
        {
            pozycjaKursora = textBox1.SelectionStart;
        }

        delegate void SetTextCallBack(string tekst);
        delegate void SetScrollCallBack();

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                using (StreamWriter sw = new StreamWriter(saveFileDialog1.FileName))
                {
                    try
                    {
                        sw.Write(webBrowser1.DocumentText);
                    }
                    catch
                    {
                        MessageBox.Show("Zapisanie pliku nie powiodło się");
                    }
                }
            }
        }

        private void czyśćToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //textBox1.Clear();
            webBrowser1.Navigate("about:blank");
            webBrowser1.Document.Write(
                "<html><head><style>body, table{font-size:10pt; font-family: verdana; margin: 3px 3px 3px 3px; font-color: black;}</style></head><body width=\"" +
                (webBrowser1.ClientSize.Width - 20).ToString() + "\">");
        }

        private void SetText(string tekst)
        {
            if (listBox1.InvokeRequired)
            {
                SetTextCallBack f = new SetTextCallBack(SetText);
                this.Invoke(f, new object[] { tekst });
            }
            else
            {
                this.listBox1.Items.Add(tekst);
            }
        }

        private void SetTextHtml(string tekst)
        {
            if (webBrowser1.InvokeRequired)
            {
                SetTextCallBack f = new SetTextCallBack(SetTextHtml);
                this.Invoke(f, new object[] { tekst });
            }
            else
            {
                this.webBrowser1.Document.Write(tekst);
            }
        }

        private void SetScroll()
        {
            if (webBrowser1.InvokeRequired)
            {
                SetScrollCallBack f = new SetScrollCallBack(SetScroll);
                this.Invoke(f);
            }
            else
            {
                this.webBrowser1.Document.Window.ScrollTo(1, Int16.MaxValue);
            }
        }

        private void WpiszTekst(string nadawca, string wiadomość)
        {
            SetTextHtml(
                "<table><tr><td width=\"10%\"><b>" + nadawca +
                "</b></td><td width=\"90%\">(" + DateTime.Now.ToShortDateString() +
                "):</td></tr>");
            SetTextHtml("<tr><td colspan=2>"+Formatuj(wiadomość)+"</td></tr></table>");
            SetTextHtml("<hr>");
            SetScroll();
        }

        private void comboBox1_TextChanged(object sender, EventArgs e)
        {
            adresIP = comboBox1.Text;
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            IPAddress serwerIP;
            try
            {
                serwerIP = IPAddress.Parse(adresIP);
            }
            catch
            {
                MessageBox.Show("Błędny adres IP");
                połączenieAktywne = false;
                return;
            }

            serwer = new TcpListener(serwerIP, (int)numericUpDown1.Value);
            try
            {
                serwer.Start();
                SetText("Oczekuje na połączenie...");
                klient = serwer.AcceptTcpClient();
                NetworkStream ns = klient.GetStream();
                SetText("Klient próbuje się połączyć");
                br = new BinaryReader(ns);
                bw = new BinaryWriter(ns);

                if (br.ReadString() == "HI")
                {
                    SetText("Klient połączony");
                    backgroundWorker2.RunWorkerAsync();
                }
                else
                {
                    SetText("Klient nie wykonał wymaganej autoryzacji. Połączenie przerwane");
                    klient.Close();
                    serwer.Stop();
                    połączenieAktywne = false;
                }
            }
            catch
            {
                SetText("Połaczenie zostało pzrerwane");
                połączenieAktywne = false;
            }
        }

        private void backgroundWorker2_DoWork(object sender, DoWorkEventArgs e)
        {
            string wiadomość;
            try
            {
                while ((wiadomość = br.ReadString()) != "###BYTE###")
                {
                    WpiszTekst("Nieznajomy", wiadomość);
                }
                klient.Close();
                serwer.Stop();
                SetText("Połączenie zostało zakończone przez klienta");
            }
            catch
            {
                SetText("Klient został rozłączony");
                połączenieAktywne = false;
                klient.Close();
                serwer.Stop();
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (!połączenieAktywne)
            {
                połączenieAktywne = true;
                backgroundWorker1.RunWorkerAsync();
                button1.Text = "Rozłącz";
            }
            else
            {
                połączenieAktywne = false;
                if (klient != null)
                {
                    klient.Close();
                    serwer.Stop();
                    backgroundWorker1.CancelAsync();
                    if (backgroundWorker2.IsBusy)
                    {
                        backgroundWorker2.CancelAsync();
                    }
                    button1.Text = "Połącz";
                }
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            WpiszTekst("ja", textBox1.Text);
            if (połączenieAktywne) bw.Write(Formatuj(textBox1.Text));
            textBox1.Clear();
        }

        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)13)
            {
                this.button2_Click(sender, e);
            }
        }

        private void PrzełączStanPrzycisku(Button button)
        {
            Color tmp = button.ForeColor;
            button.ForeColor = button.BackColor;
            button.BackColor = tmp;            
        }

        private void button3_Click(object sender, EventArgs e)
        {
            pogrubienie = !pogrubienie;
            PrzełączStanPrzycisku(button3);
        }

        private void button4_Click(object sender, EventArgs e)
        {
            pochylenie = !pochylenie;
            PrzełączStanPrzycisku(button4);
        }

        private string Formatuj(string tekst)
        {
            if (pogrubienie) tekst = "<b>" + tekst + "</b>";
            if (pochylenie) tekst = "<i>" + tekst + "</i>";
            return tekst;
        }
    }
}
