﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Net;
using System.Net.Sockets;
using System.IO;

namespace ChatKlient
{
    public partial class Form1 : Form
    {
        private TcpClient client;
        private string addressIPOfServer = "127.0.0.1"; //na sztywno adres IP serwera
        private BinaryWriter writer;
        private bool isActive = false;

        public Form1()
        {
            InitializeComponent();

            webBrowser1.Document.Write("<html><head><style>body.table{font-size:10pt; font-family: Verdana; margin: 3px 3px 3px 3px; font-color: black;}</style></head><body width=\"" + (webBrowser1.ClientSize.Width - 20).ToString() + "\">");

        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            UdpClient client = new UdpClient(2500); //na sztywno port 2500
            IPEndPoint addressIP = new IPEndPoint(IPAddress.Parse(addressIPOfServer), 0);
            string message = "";
            while (!backgroundWorker1.CancellationPending)
            {
                Byte[] bufor = client.Receive(ref addressIP);
                string data = Encoding.UTF8.GetString(bufor);
                string[] cmd = data.Split(new char[] { ':' });
                if (cmd[1] == "BYE")
                {
                    _AddText("system", "klient odłączony");
                    client.Close();
                    return;
                }
                if (cmd.Length > 2)
                {
                    message = cmd[2];
                    for (int i = 3; i < cmd.Length; i++)
                    {
                        message += ":" + cmd[1];
                    }
                }
                _AddText(cmd[0], message);
            }
        }

        private void _AddText(string nick, string message)
        {
            AddTextHtml("<table><tr><td width=\"10%\"><b>[" + nick + "]:</b></td>");
            AddTextHtml("<td colspan=2>" + message + "</td></tr></table>");
            SetScroll();
        }

        #region "Obsługa wątku UI"
        delegate void AddTextCallBack(ListBox listBox, string text);
        private void AddText(ListBox listBox, string text)
        {
            if (listBox.InvokeRequired)
            {
                AddTextCallBack f = new AddTextCallBack(AddText);
                this.Invoke(f, new object[] { listBox, text });
            }
            else
            {
                listBox.Items.Add(text);
            }
        }

        delegate void AddTextHtmlCallBack(string text);
        private void AddTextHtml(string text)
        {
            if (webBrowser1.InvokeRequired)
            {
                AddTextHtmlCallBack f = new AddTextHtmlCallBack(AddTextHtml);
                this.Invoke(f, new object[] { text });
            }
            else
            {
                webBrowser1.Document.Write(text);
            }
        }

        delegate void SetScrollCallBack();
        private void SetScroll()
        {
            if (webBrowser1.InvokeRequired)
            {
                SetScrollCallBack f = new SetScrollCallBack(SetScroll);
                this.Invoke(f);
            }
            else
            {
                webBrowser1.Document.Window.ScrollTo(1, int.MaxValue);
            }
        }

        /*
        delegate void RemoveTextCallBack(int i);
        private void RemoveText(int i)
        {
            if (listBox2.InvokeRequired)
            {
                RemoveTextCallBack f = new RemoveTextCallBack(RemoveText);
                this.Invoke(f, new object[] { i });
            }
            else
            {
                listBox2.Items.RemoveAt(i);
            }
        }
        */
        #endregion

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                if (textBox1.Text != String.Empty)
                {
                    client = new TcpClient(addressIPOfServer, 100); //na sztywno 100
                    textBox1.ReadOnly = true;
                    NetworkStream ns = client.GetStream();
                    writer = new BinaryWriter(ns);
                    writer.Write(textBox1.Text + ":HI:" + "null");
                    BinaryReader reader = new BinaryReader(ns);
                    string answer = reader.ReadString();
                    if (answer == "HI")
                    {
                        backgroundWorker1.RunWorkerAsync();
                        isActive = true;
                        button1.Enabled = false;
                        button2.Enabled = true;
                    }
                    else
                    {
                        button1.Enabled = true;
                        button2.Enabled = false;
                        MessageBox.Show("Serwer odmawia nawiązania połczenia");
                    }
                }
                else MessageBox.Show("Wpisz swój login");
            }
            catch (Exception exc)
            {
                button1.Enabled = true;
                button2.Enabled = false;
                MessageBox.Show("Błąd przy nawiązywaniu połączenia: " + exc.Message);                
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            if (isActive && textBox2.Text != String.Empty)
            {
                writer.Write(textBox1.Text + ":SAY:" + textBox2.Text);
                textBox2.Text = String.Empty;
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (writer != null)
            {
                try
                {
                    writer.Write(textBox1.Text + ":BYE:" + "null");
                    writer.Close();
                }
                catch (Exception exc)
                {
                    MessageBox.Show(exc.Message);                    
                }
                finally
                {
                    if (backgroundWorker1.IsBusy)
                    {
                        backgroundWorker1.CancelAsync();
                    }
                    if (client != null) client.Close();
                }
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}
