﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Net;
using System.Net.Sockets;
using System.IO;

namespace Chat
{
    public partial class Form1 : Form
    {
        //format wiadomości: nadawca:komenda:treść
        //komendy: HI, BYE, ERROR, SAY

        private TcpListener server;
        private TcpClient client;
        private List<BackgroundWorker> clientList;
        private List<string> clientNames;
        private bool isServerActive;


        public Form1()
        {
            InitializeComponent();

            clientList = new List<BackgroundWorker>();
            clientNames = new List<string>();
            isServerActive = false;
            webBrowser1.Document.Write("<html><head><style>body.table{font-size:10pt; font-family: Verdana; margin: 3px 3px 3px 3px; font-color: black;}</style></head><body width=\"" + (webBrowser1.ClientSize.Width - 20).ToString() + "\">");
        }

        private void _AddText(string nick, string message)
        {
            AddTextHtml("<table><tr><td width=\"10%\"><b>[" + nick + "]:</b></td>");
            AddTextHtml("<td colspan=2>"+message+"</td></tr></table>");
            SetScroll();
        }

        private void SendUdpMessage(string message)
        {
            foreach (string user in listBox2.Items)
            {
                using (UdpClient clientUdp = new UdpClient(user, 2500))
                {
                    byte[] bufor = Encoding.UTF8.GetBytes(message);
                    clientUdp.Send(bufor, bufor.Length);
                }
            }
        }

        #region "Obsługa wątku UI"
        delegate void AddTextCallBack(ListBox listBox, string text);
        private void AddText(ListBox listBox, string text)
        {
            if (listBox.InvokeRequired)
            {
                AddTextCallBack f = new AddTextCallBack(AddText);
                this.Invoke(f, new object[] { listBox, text });
            }
            else
            {
                listBox.Items.Add(text);
            }
        }

        delegate void AddTextHtmlCallBack(string text);
        private void AddTextHtml(string text)
        {
            if (webBrowser1.InvokeRequired)
            {
                AddTextHtmlCallBack f = new AddTextHtmlCallBack(AddTextHtml);
                this.Invoke(f, new object[] { text });
            }
            else
            {
                webBrowser1.Document.Write(text);
            }
        }

        delegate void SetScrollCallBack();
        private void SetScroll()
        {
            if (webBrowser1.InvokeRequired)
            {
                SetScrollCallBack f = new SetScrollCallBack(SetScroll);
                this.Invoke(f);
            }
            else
            {
                webBrowser1.Document.Window.ScrollTo(1, int.MaxValue);
            }
        }

        delegate void RemoveTextCallBack(int i);
        private void RemoveText(int i)
        {
            if (listBox2.InvokeRequired)
            {
                RemoveTextCallBack f = new RemoveTextCallBack(RemoveText);
                this.Invoke(f, new object[] { i });
            }
            else
            {
                listBox2.Items.RemoveAt(i);
            }
        }
        #endregion

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            try
            {
                server.Start();
                AddText(listBox1, "Serwer oczekuje na połączenie...");
                while (true)
                {
                    client = server.AcceptTcpClient();
                    AddText(listBox1, "Klient podłączony");
                    NetworkStream ns = client.GetStream();
                    BinaryReader br = new BinaryReader(ns);
                    string data = br.ReadString();
                    string[] cmd = data.Split(new char[] { ':' });
                    if (cmd[1] == "HI")
                    {
                        BinaryWriter bw = new BinaryWriter(ns);
                        if (clientNames.BinarySearch(cmd[0]) > -1)
                        {
                            bw.Write("Błąd: Użytkownika o podanej nazzwie już istnieje");
                        }
                        else
                        {
                            bw.Write("HI");
                            BackgroundWorker clientThread = new BackgroundWorker();
                            clientThread.WorkerSupportsCancellation = true;
                            clientThread.DoWork += new DoWorkEventHandler(clientThread_DoWork);
                            clientNames.Add(cmd[0]);
                            clientList.Add(clientThread);
                            clientThread.RunWorkerAsync();
                            SendUdpMessage("administrator:SAY:Użytkownika " + cmd[0] + " dołączył do rozmowy");
                        }
                    }
                    else
                    {
                        MessageBox.Show("Klient nie dokonał autoryzacji",this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        isServerActive = false;
                        client.Close();
                    }
                }
            }
            catch
            {
                isServerActive = false;
                server.Stop();
                AddText(listBox1, "Połączenie przerwane");
            }
        }

        private void clientThread_DoWork(object sender, DoWorkEventArgs e)
        {
            IPEndPoint ip = (IPEndPoint)client.Client.RemoteEndPoint;
            AddText(listBox2, ip.Address.ToString());
            AddText(listBox1, "Klient [" + ip.Address.ToString() + "] uwierzytelniony");
            NetworkStream ns = client.GetStream();
            BinaryReader br = new BinaryReader(ns);
            string[] cmd = null;
            BackgroundWorker bw = (BackgroundWorker)sender;
            try
            {
                while ((cmd = br.ReadString().Split(new char[] { ':' }))[1] != "BYE" && bw.CancellationPending == false)
                {
                    string message = null;
                    if (cmd.Length > 2)
                    {
                        message = cmd[2];
                        for (int i = 3; i < cmd.Length; i++)
                        {
                            message += ":" + cmd[1];
                        }
                    }
                    switch (cmd[1])
                    {
                        case "SAY":
                            _AddText(cmd[0], message);
                            SendUdpMessage(cmd[0] + ":" + cmd[1] + ":" + message);
                            break;
                    }
                }
                AddText(listBox1, "Użytkownik [" + cmd[0] + "] opuścił serwer");
                for (int i = 0; i < listBox2.Items.Count; ++i)
                {
                    if (ip.Address.ToString() == listBox2.Items[i].ToString())
                    {
                        RemoveText(i);
                        clientNames.RemoveAt(i);
                        clientList.RemoveAt(i);
                    }
                }
                SendUdpMessage("administrator:SAY:Użytkownik " + cmd[0] + " opuścił rozmowę");
                br.Close();
                ns.Close();
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //Start
        private void button1_Click(object sender, EventArgs e)
        {
            if (!isServerActive)
            {
                try
                {
                    server = new TcpListener(IPAddress.Parse(comboBox1.Text), (int)numericUpDown1.Value);
                    backgroundWorker1.RunWorkerAsync();
                    isServerActive = true;
                }
                catch (Exception exc)
                {
                    MessageBox.Show("Błąd inicjacji serwera (" + exc.Message + ")", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        //Stop
        private void button2_Click(object sender, EventArgs e)
        {
            if (isServerActive)
            {
                SendUdpMessage("administrator:SAY:Serwer zostanie zatrzymany");
                if (client != null) client.Close();
                server.Stop();
                listBox1.Items.Add("Serwer zatrzymany");
                listBox2.Items.Clear();
                clientNames.Clear();
                clientList.Clear();
            }
        }

        //Usuń
        private void button3_Click(object sender, EventArgs e)
        {
            int index = listBox2.SelectedIndex;
            using (UdpClient udpClient = new UdpClient(listBox2.Items[index].ToString(), 2500))
            {
                byte[] bufor = Encoding.UTF8.GetBytes("administrator:SAY:Zostałeś odłączony");
                udpClient.Send(bufor, bufor.Length);
                byte[] bufor2 = Encoding.UTF8.GetBytes("admninistrator:BYE:pusty");
                udpClient.Send(bufor2, bufor2.Length);
            }
            listBox1.Items.Add("Klient [" + listBox2.Items[index].ToString() + "] rozłączony");
            clientList[index].CancelAsync();
            SendUdpMessage("administrator:SAY:Użytkownik " + listBox2.Items[index].ToString() + " został odłączony");
            listBox2.Items.RemoveAt(index);
            clientList.RemoveAt(index);
            clientNames.RemoveAt(index);
        }

        //Wyślij
        private void button4_Click(object sender, EventArgs e)
        {
            string s = textBox1.Text;
            //if(textBox1.Text != String.Empty && textBox1.Text.Trim()!= String.Empty)
            if (!String.IsNullOrEmpty(s))
            {
                _AddText("administrator", s);
                if (isServerActive) SendUdpMessage("administrator:SAY:" + s);
            }
        }
    }
}
