﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Net;
using System.IO;

namespace KlientFTP
{
    class FtpClient
    {
        const string protocol = "ftp://";

        public string Username;
        public string Password;                

        private string ftpAddress;
        public string FtpAddress
        {
            get
            {
                if(ftpAddress.StartsWith(protocol))
                    return ftpAddress;
                else
                    return protocol + ftpAddress;
            }
            set
            {
                if (!value.StartsWith(protocol)) value = protocol + value;
                ftpAddress = value;
            }
        }

        public FtpClient(string ftpAddress, string username, string password)
        {
            this.FtpAddress = ftpAddress;
            this.Username = username;
            this.Password = password;
            
        }

        public List<string> ListDirectory()
        {
            List<string> entries = new List<string>();
            FtpWebRequest request;
            try
            {
                request = (FtpWebRequest)WebRequest.Create(FtpAddress);
                request.Method = WebRequestMethods.Ftp.ListDirectoryDetails;
                request.Credentials = new NetworkCredential(this.Username, this.Password);
                request.KeepAlive = false;
                using (FtpWebResponse response = (FtpWebResponse)request.GetResponse())
                {
                    Stream s = response.GetResponseStream();
                    using (StreamReader sr = new StreamReader(s))
                    {
                        string entry;
                        while ((entry = sr.ReadLine()) != null)
                        {
                            entries.Add(entry);
                        }
                    }
                    return entries;
                }
            }
            catch(Exception exc)
            {
                throw new Exception("Nie można nawiązać połączenia z serwerem FTP: " + FtpAddress, exc);
            }
        }
        
        public List<string> EnterSubDirectory(string subdirectoryName)
        {
            if (FtpAddress.Last() != '/') FtpAddress += "/";
            FtpAddress += subdirectoryName;
            return ListDirectory();
        }

        public List<string> EnterParentDirectory()
        {
            FtpAddress = FtpAddress.Remove(FtpAddress.LastIndexOf('/'));
            return ListDirectory();
        }

        public void DownloadFileAsync(string remoteFilePath, string localFilePath)
        {
            WebClient client = new WebClient();
            try
            {
                Uri uri = new Uri(remoteFilePath);
                if(File.Exists(localFilePath)) throw new IOException("Plik "+localFilePath+" już ostnieje");
                else
                {
                    client.DownloadFileCompleted += client_DownloadFileCompleted;
                    client.DownloadProgressChanged += client_DownloadProgressChanged;
                    client.Credentials = new NetworkCredential(this.Username, this.Password);
                    client.DownloadFileAsync(uri, localFilePath);
                }
            }
            catch
            {                
                throw;
            }
            finally
            {
                client.Dispose();
            }
        }

        //dodane zdarzenia
        public event DownloadProgressChangedEventHandler DownloadProgressChanged;
        public event System.ComponentModel.AsyncCompletedEventHandler DownloadFileCompleted;

        void client_DownloadProgressChanged(object sender, DownloadProgressChangedEventArgs e)
        {
            if (DownloadProgressChanged != null) DownloadProgressChanged(sender, e);
        }

        void client_DownloadFileCompleted(object sender, System.ComponentModel.AsyncCompletedEventArgs e)
        {
            if (DownloadFileCompleted != null) DownloadFileCompleted(sender, e);
        }
    }
}
