﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace KlientFTP
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            textBox4.Text = System.IO.Directory.GetCurrentDirectory();            
        }

        private void button5_Click(object sender, EventArgs e)
        {
            folderBrowserDialog1.SelectedPath = textBox4.Text;
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox4.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        //-------------- zbudować FtpClient

        private FtpClient klientFtp;

        private void PrintFtpEntries(List<string> entries)
        {
            List<string> _entries = new List<string>(entries.Count());
            foreach (string entry in entries)
            {
                string name = entry.Substring(entry.LastIndexOf(' ') + 1);
                if (name != ".." && name != ".")
                {
                    switch (entry[0])
                    {
                        case 'd':
                            _entries.Add("[" + name + "]");
                            break;
                        case 'l':
                            _entries.Add("->" + name);
                            break;
                        default:
                            _entries.Add(name);
                            break;
                    }
                }
            }
            
            listBox1.BeginUpdate();
            listBox1.Items.Clear();
            listBox1.Items.Add("[..]");
            listBox1.Items.AddRange(_entries.ToArray());
            listBox1.EndUpdate();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                this.Cursor = Cursors.WaitCursor;
                string nazwaSerwera = textBox1.Text;
                //nazwa serwera nie może zaczynać się od ftp://
                if (nazwaSerwera.StartsWith("ftp://")) nazwaSerwera = nazwaSerwera.Replace("ftp://", "");
                klientFtp = new FtpClient(nazwaSerwera, textBox2.Text, textBox3.Text);
                PrintFtpEntries(klientFtp.ListDirectory());
                textBox1.Text = klientFtp.FtpAddress;
                button1.Enabled = false;
                button2.Enabled = true;
                button3.Enabled = true;
                button4.Enabled = true;
                klientFtp.DownloadFileCompleted += klientFtp_DownloadFileCompleted;
                klientFtp.DownloadProgressChanged += klientFtp_DownloadProgressChanged;
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd połączenia z serwerem FTP: " + exc.Message);
            }
            finally
            {
                this.Cursor = Cursors.Default;
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            PrintFtpEntries(klientFtp.EnterParentDirectory());
            textBox1.Text = klientFtp.FtpAddress;
        }

        private void listBox1_DoubleClick(object sender, EventArgs e)
        {
            try
            {
                this.Cursor = Cursors.WaitCursor;
                int index = listBox1.SelectedIndex;
                string nazwa = listBox1.SelectedItem.ToString();
                if (index < 0) return;
                if (index == 0)
                {
                    PrintFtpEntries(klientFtp.EnterParentDirectory());
                }
                else
                {
                    if (nazwa[0] != '[') return;
                    nazwa = nazwa.Substring(1, nazwa.LastIndexOf(']') - 1);
                    PrintFtpEntries(klientFtp.EnterSubDirectory(nazwa));                    
                }
                textBox1.Text = klientFtp.FtpAddress;
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd połączenia z serwerem FTP: " + exc.Message);
            }
            finally
            {
                this.Cursor = Cursors.Default;
            }
        }

        private void listBox1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter) listBox1_DoubleClick(sender, null);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            try
            {
                this.Cursor = Cursors.WaitCursor;
                int index = listBox1.SelectedIndex;
                string nazwa = listBox1.SelectedItem.ToString();
                if (index < 0) return;
                if(nazwa.Contains('[')) return;
                else
                {
                    string localFilename = System.IO.Path.Combine(textBox4.Text, nazwa);
                    string remoteFilename = textBox1.Text;
                    if (remoteFilename.Last() != '/') remoteFilename += "/";
                    remoteFilename += nazwa;
                    //klientFtp.DownloadFileCompleted += klientFtp_DownloadFileCompleted;
                    //klientFtp.DownloadProgressChanged += klientFtp_DownloadProgressChanged;
                    klientFtp.DownloadFileAsync(remoteFilename, localFilename);
                    listBox2.Items.Add("Pobieranie rozpoczęte: " + remoteFilename + " -> " + localFilename);                                        
                }                
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd pobierania pliku z serwera FTP: " + exc.Message);
            }
            finally
            {
                this.Cursor = Cursors.Default;
            }
        }

        void klientFtp_DownloadProgressChanged(object sender, System.Net.DownloadProgressChangedEventArgs e)
        {
            listBox2.Items.Add("Pobieranie: " + e.BytesReceived + " bajtów");
        }

        void klientFtp_DownloadFileCompleted(object sender, AsyncCompletedEventArgs e)
        {
            if(e.Error==null) listBox2.Items.Add("Pobieranie pliku zakończone");
            else listBox2.Items.Add("Pobieranie pliku nie powiodło się: "+e.Error.Message);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            listBox1.Items.Clear();
            klientFtp.DownloadFileCompleted -= klientFtp_DownloadFileCompleted;
            klientFtp.DownloadProgressChanged -= klientFtp_DownloadProgressChanged;                    
            klientFtp = null;
            button1.Enabled = true;
            button2.Enabled = false;
            button3.Enabled = false;
            button4.Enabled = false;
        }
    }
}
