﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Net.NetworkInformation;
using System.Net;

namespace Traceroute
{
    public partial class Form1 : Form
    {
        private int wartośćTTL;
        private IPAddress adresDocelowy;
        private Ping ping = new Ping();
        private byte[] bufor;


        public Form1()
        {
            InitializeComponent();
            ping.PingCompleted += new PingCompletedEventHandler(Ping_Completed);
        }

        private void Ping_Completed(object sender, PingCompletedEventArgs e)
        {
            if (e.Error != null)
            {
                listBox1.Items.Add(e.Error.Message);
                return;
            }
            if (e.Cancelled)
            {
                listBox1.Items.Add("Przerwano na żądanie użytkownika");
                return;
            }
            else
            {                
                switch(e.Reply.Status)
                {
                    case IPStatus.TtlExpired:
                        listBox1.Items.Add("Skok " + wartośćTTL.ToString() + ", host: " + e.Reply.Address.ToString());
                        break;
                    case IPStatus.Success:
                        listBox1.Items.Add("Skok " + wartośćTTL.ToString() + ", host: " + e.Reply.Address.ToString());                        
                        break;
                    case IPStatus.TimedOut:
                        listBox1.Items.Add("Skok " + wartośćTTL.ToString() + ", host: Upłynął czasu oczekiwania na odpowiedź");
                        break;
                }                
                if (e.Reply.Address.ToString() == adresDocelowy.ToString())
                {
                    listBox1.Items.Add("Badanie trasy zakończone");
                    button1.Enabled = true;
                    return;
                }
                if (wartośćTTL++ < numericUpDown1.Value)
                {
                    PingOptions opcjePing = new PingOptions(wartośćTTL, true);
                    ping.SendAsync(textBox1.Text, (int)numericUpDown1.Value, bufor, opcjePing, null);
                }
                else
                {
                    listBox1.Items.Add("Przekroczono maksymalną liczbę przeskoków");
                }
            }
        }
        
        private void button1_Click(object sender, EventArgs e)
        {
            listBox1.Items.Clear();

            wartośćTTL = 1;
            PingOptions opcjePing = new PingOptions(wartośćTTL, true);
            int wielkośćBufora;
            string dane = string.Empty;

            try
            {
                wielkośćBufora = int.Parse(comboBox1.Text);
            }
            catch (Exception exc)
            {                
                MessageBox.Show("Błąd: " + exc.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            try
            {
                adresDocelowy = IPAddress.Parse(textBox1.Text);
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd: " + exc.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            for (int i = 0; i < wielkośćBufora; ++i) dane += "a";

            bufor = Encoding.ASCII.GetBytes(dane);            
            ping.SendAsync(textBox1.Text, (int)numericUpDown2.Value, bufor, opcjePing, null);
            listBox1.Items.Add("Rozpoczęcie badania drogi do " + textBox1.Text);
            button1.Enabled = false;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            ping.SendAsyncCancel();
            button1.Enabled = true;
        }
    }
}
