﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Net.NetworkInformation;
using System.Net;

namespace NetDetect
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        #region Skopiowane z projektu Ping i zmpdyfikowane gdzie zaznaczono
        public void WyślijPing(IPAddress adres, int czasOczekiwania, byte[] dane, PingOptions opcje) //1: string -> IPAddress
        {
            Ping ping = new Ping();
            ping.PingCompleted += new PingCompletedEventHandler(OdebranaInformacjaZwrotna);
            try
            {
                ping.SendAsync(adres, czasOczekiwania, dane, opcje, null);
            }
            catch (Exception exc)
            {
                listBox1.Items.Add("Błąd (" + adres + "): " + exc.Message);
                listBox1.Refresh();
            }
        }

        private void OdebranaInformacjaZwrotna(object sender, PingCompletedEventArgs e)
        {
            if (e.Cancelled || e.Error != null)
            {
                listBox1.Items.Add("Wystąpił błąd lub operacja została przerwana");
                ((sender as Ping) as IDisposable).Dispose();
                return;
            }

            PingReply odpowiedź = e.Reply;
            if (odpowiedź.Status == IPStatus.Success)
            {
                listBox1.Items.Add("Odpowiedź z " + odpowiedź.Address.ToString() + ", odesłano " + odpowiedź.Buffer.Length + " bajtów, czas: " + odpowiedź.RoundtripTime.ToString() + " ms, TTL: " + odpowiedź.Options.Ttl.ToString());                
            }
            else listBox1.Items.Add("Błąd lub brak odpowiedzi z " + e.Reply.Address + ", stan: " + odpowiedź.Status.ToString());
            listBox1.Refresh();
        }
        #endregion

        private void button1_Click(object sender, EventArgs e)
        {
            Cursor = Cursors.WaitCursor;

            IPAddress początkoweIP = null;
            IPAddress końcoweIP = null;

            //parsowanie adresu IP
            try
            {
                początkoweIP = IPAddress.Parse(textBox1.Text);
                końcoweIP = IPAddress.Parse(textBox2.Text);
            }
            catch(Exception exc)
            {
                MessageBox.Show("Błąd: " + exc.Message);
            }

            byte[] początkowyIP_bajty = początkoweIP.GetAddressBytes();
            byte[] końcowyIP_bajty = końcoweIP.GetAddressBytes();

            PingOptions opcjePing = new PingOptions();
            opcjePing.Ttl = 128;
            opcjePing.DontFragment = true;
            string dane = string.Empty;
            for (int i = 0; i < 32; ++i) dane += "a";
            byte[] bufor = Encoding.ASCII.GetBytes(dane);            
            int timeout = 3000;

            for (byte oktet0 = początkowyIP_bajty[0]; oktet0 <= końcowyIP_bajty[0]; ++oktet0)
            {
                for (byte oktet1 = początkowyIP_bajty[1]; oktet1 <= końcowyIP_bajty[1]; ++oktet1)
                {
                    for (byte oktet2 = początkowyIP_bajty[2]; oktet2 <= końcowyIP_bajty[2]; ++oktet2)
                    {
                        for (byte oktet3 = początkowyIP_bajty[3]; oktet3 <= końcowyIP_bajty[3]; ++oktet3)
                        {
                            IPAddress adres = new IPAddress(new byte[] { oktet0, oktet1, oktet2, oktet3 });
                            listBox1.Items.Add("Wysłany ping do: " + adres);
                            WyślijPing(adres, timeout, bufor, opcjePing);
                        }
                    }
                }
            }

            Cursor = Cursors.Default;
        }
    }
}
