﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Net;
using System.IO;

namespace HTTP_PobieraniePliku
{
    public partial class Form1 : Form
    {
        const int bieżącaWersja = 1;

        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                int odczytanaWersja = 1;
                WebRequest request = WebRequest.Create("http://www.fizyka.umk.pl/~jacek/dydaktyka/net/zrodla/2014L_zaawansowane/wersja.txt");
                request.Credentials = CredentialCache.DefaultNetworkCredentials;

                HttpWebResponse httpResponse = (HttpWebResponse)request.GetResponse();
                Stream s = httpResponse.GetResponseStream();
                StreamReader sr = new StreamReader(s);

                string odczytanaWersja_łańcuch = sr.ReadToEnd();
                try
                {
                    odczytanaWersja = Convert.ToInt32(odczytanaWersja_łańcuch);
                }
                catch
                {
                    MessageBox.Show("Błąd w trakcie sprawdzania dostępnej wersji programu");
                }

                if (odczytanaWersja > bieżącaWersja)
                {
                    DialogResult dr = MessageBox.Show("Dostępna jest nowsza wersja programu. Czy chcesz ją pobrać?", this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                    if (dr == DialogResult.Yes)
                    {
                        saveFileDialog1.FileName = "HTTP_PobieraniePliku.exe";
                        if (saveFileDialog1.ShowDialog() == DialogResult.OK)
                        {
                            try
                            {
                                //pobieranie pliku
                                WebClient klientHTTP = new WebClient();
                                klientHTTP.DownloadFile("http://www.fizyka.umk.pl/~jacek/dydaktyka/net/zrodla/2014L_zaawansowane/HTTP_PobieraniePliku.exe", saveFileDialog1.FileName);
                            }
                            catch (Exception exc)
                            {
                                MessageBox.Show("Błąd podczas pobierania pliku: " + exc.Message);
                            }
                        }
                    }
                }
                else
                {
                    MessageBox.Show("Program jest aktualny", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd: " + exc.Message);
            }
        }
    }
}
