﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Net;
using System.Net.Sockets;
using System.IO;

namespace TcpSerwer
{
    public partial class Form1 : Form
    {
        TcpListener tcpListener;
        TcpClient tcpClient;

        public Form1()
        {
            InitializeComponent();
        }
        

        private void button1_Click(object sender, EventArgs e)
        {
            WłączNasłuchiwanie();
            listBox1.Items.Add("Czekam na połączenie...");
        }

        private void WłączNasłuchiwanie()
        {
            tcpListener = new TcpListener(IPAddress.Parse(textBox1.Text), Convert.ToInt16(numericUpDown1.Value));
            tcpListener.Start();
            tcpListener.BeginAcceptTcpClient(new AsyncCallback(AcceptTCPCallback), tcpListener);
        }

        private void AcceptTCPCallback(IAsyncResult asyncResult)
        {
            TcpListener tcpListenerAsync = asyncResult.AsyncState as TcpListener;
            tcpClient = tcpListenerAsync.EndAcceptTcpClient(asyncResult);
            string tekst = new StreamReader(tcpClient.GetStream()).ReadLine();
            if (tekst == null || tekst == "") DodajDoListBox("Nawiązano połączenie");
            else DodajDoListBox("Wiadomość: \"" + tekst + "\" z komputera o numerze MAC: " + Dns.GetHostEntry(textBox1.Text).AddressList[0]);
            tcpClient.Close();            
            tcpListener.Stop();
            WłączNasłuchiwanie();
        }

        private delegate void DodajDoListBoxCallback(string tekst);
        private void DodajDoListBox(string tekst)
        {
            //tekst = "Wiadomość: " + tekst;
            //każde połączenie w innym wątku - stąd kłopot z wyświetlaniem w kontrolkach (wątek UI)
            if (listBox1.InvokeRequired)
            {
                DodajDoListBoxCallback callback = new DodajDoListBoxCallback(DodajDoListBox);
                this.Invoke(callback, new object[] { tekst });
            }
            else
            {
                listBox1.Items.Add(tekst);
            }
        }
    }
}
