﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

//using System.Net;
//using System.Net.Sockets;
using System.Net.NetworkInformation;

namespace InformacjePing
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        public void WyślijPing(string adres, int czasOczekiwania, byte[] dane, PingOptions opcje)
        {
            Ping ping = new Ping();
            ping.PingCompleted += new PingCompletedEventHandler(OdebranaInformacjaZwrotna);
            try
            {
                ping.SendAsync(adres, czasOczekiwania, dane, opcje, null);
            }
            catch(Exception exc)
            {
                listBox1.Items.Add("Błąd (" + adres + "): " + exc.Message);
            }
        }

        private void OdebranaInformacjaZwrotna(object sender, PingCompletedEventArgs e)
        {
            if (e.Cancelled || e.Error != null)
            {
                listBox1.Items.Add("Wystąpił błąd lub operacja została przerwana");
                ((sender as Ping) as IDisposable).Dispose();
                return;
            }

            PingReply odpowiedź = e.Reply;
            if (odpowiedź.Status == IPStatus.Success)
            {
                listBox1.Items.Add("Odpowiedź z " + odpowiedź.Address.ToString() + ", odesłano " + odpowiedź.Buffer.Length + " bajtów, czas: " + odpowiedź.RoundtripTime.ToString() + " ms, TTL: " + odpowiedź.Options.Ttl.ToString());
            }
            else listBox1.Items.Add("Błąd lub brak odpowiedzi z " + e.Reply.Address + ", stan: " + odpowiedź.Status.ToString());
        }

        private void button1_Click(object sender, EventArgs e)
        {
            int wielkośćBufora = 32;
            try
            {
                wielkośćBufora = Convert.ToInt32(comboBox1.Text);
            }
            catch
            {
                comboBox1.Text = wielkośćBufora.ToString();
                wielkośćBufora = 32;
            }

            string bufor = String.Empty;
            for (int i = 0; i < wielkośćBufora; ++i)
            {
                bufor += "a";
            }

            PingOptions opcje = new PingOptions();
            opcje.Ttl = 32;
            opcje.DontFragment = true;

            byte[] dane; //pakiet
            dane = Encoding.ASCII.GetBytes("bufor");

            for (int i = 0; i < 10; ++i)
            {
                WyślijPing(textBox1.Text, Convert.ToInt32(numericUpDown1.Value), dane, opcje);
            }
        }
    }
}
