﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Xml.Linq;

namespace EdytorXML
{
    public partial class Form1 : Form
    {
        private Model model = new Model();

        public Form1()
        {
            InitializeComponent();

            //odtwarzać edytowany ostatnio plik (ustawienia aplikacji)
        }

        public void OdświeżWidokDrzewa()
        {
            treeView1.BeginUpdate();
            model.TwórzDrzewoNaPodstawieModelu(treeView1.Nodes);
            treeView1.EndUpdate();
            treeView1.ExpandAll();
            treeView1.Nodes[0].EnsureVisible();
            treeView1.SelectedNode = treeView1.Nodes[0];
        }

        private void czytajPlikToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (model.CzyLokalnyPlik) openFileDialog1.FileName = model.ŚcieżkaDoPliku;
            DialogResult dr = openFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                Cursor = Cursors.WaitCursor;
                try
                {
                    model.CzytajDaneZPlikuXml(openFileDialog1.FileName);
                    nazwaPlikuToolStripStatusLabel.Text = System.IO.Path.GetFileName(model.ŚcieżkaDoPliku);
                    OdświeżWidokDrzewa();
                    dodajOstatnioOtwieranyPlik(openFileDialog1.FileName);
                }
                catch (Exception exc)
                {
                    MessageBox.Show(
                        "Nie powiodło się odczytanie pliku XML \"" + openFileDialog1.FileName + "\"\nBłąd: " + exc.Message,
                        this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                finally
                {
                    Cursor = Cursors.Default;
                }
            }
        }

        void ostatnioOtwieranePliki_Click(object sender, EventArgs e)
        {
            Cursor = Cursors.WaitCursor;
            try
            {
                string uri = (sender as ToolStripMenuItem).Text;
                model.CzytajDaneZPlikuXml(uri);
                nazwaPlikuToolStripStatusLabel.Text = System.IO.Path.GetFileName(model.ŚcieżkaDoPliku);
                OdświeżWidokDrzewa();
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Nie powiodło się odczytanie pliku XML \"" + openFileDialog1.FileName + "\"\nBłąd: " + exc.Message,
                    this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                Cursor = Cursors.Default;
            }
        }

        private void dodajOstatnioOtwieranyPlik(string uri)
        {
            ToolStripMenuItem elementMenu = new ToolStripMenuItem(uri);            
            foreach (ToolStripMenuItem em in toolStripMenuItem2.DropDownItems) 
                if (em.Text == uri) return;
            elementMenu.Click += ostatnioOtwieranePliki_Click;
            toolStripMenuItem2.DropDownItems.Add(elementMenu);
        }

        private void otworzAdresURLToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (OknoEdycjiURL oknoEdycjiURL = new OknoEdycjiURL())
            {
                try
                {
                    if (oknoEdycjiURL.URL == null || oknoEdycjiURL.URL == "") oknoEdycjiURL.URL = "http://www.nbp.pl/kursy/xml/LastA.xml";
                    if (oknoEdycjiURL.ShowDialog() == DialogResult.OK)
                    {
                        this.Cursor = Cursors.WaitCursor;
                        model.CzytajDaneZUrl(oknoEdycjiURL.URL);
                        nazwaPlikuToolStripStatusLabel.Text = oknoEdycjiURL.URL;
                        OdświeżWidokDrzewa();
                        dodajOstatnioOtwieranyPlik(oknoEdycjiURL.URL);
                    }
                }
                catch (Exception exc)
                {
                    MessageBox.Show(
                        "Nie powiodło się odczytanie pliku XML z adresu \"" + oknoEdycjiURL.URL + ".\nBłąd: " + exc.Message);
                }                
                finally
                {
                    this.Cursor = Cursors.Default;
                }
            }
        }

        private void zapiszDoPlikuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (model.CzyLokalnyPlik) saveFileDialog1.FileName = model.ŚcieżkaDoPliku;
            DialogResult dr = saveFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                try
                {
                    model.ZapiszDaneDoPliku(saveFileDialog1.FileName);
                    nazwaPlikuToolStripStatusLabel.Text = model.ŚcieżkaDoPliku;
                }
                catch (Exception exc)
                {
                    MessageBox.Show(
                        "Nie powiodło się zapisanie pliku XML \"" + saveFileDialog1.FileName + "\"\nBłąd: " + exc.Message,
                        this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        private void toolStripMenuItem4_Click(object sender, EventArgs e)
        {
            treeView1.CollapseAll();
        }

        private void rozwińWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            treeView1.ExpandAll();
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = treeView1.BackColor;
            DialogResult dr = colorDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                treeView1.BackColor = colorDialog1.Color;
            }            
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = treeView1.Font;
            fontDialog1.Color = treeView1.ForeColor;
            DialogResult dr = fontDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                treeView1.Font = fontDialog1.Font;
                treeView1.ForeColor = fontDialog1.Color;
            }
        }

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            model.ZapiszDaneDoPliku(model.ŚcieżkaDoPliku);            
        }

        private void drukujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (model.ŚcieżkaDoPliku == null)
            {
                MessageBox.Show("Można wydrukować tylko po wczytaniu z lokalnego pliku", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            Drukowanie drukowanie = new Drukowanie();
            drukowanie.DrukujPlikTekstowy(model.ŚcieżkaDoPliku, new Font(FontFamily.GenericMonospace, 12));
        }

        bool szukanie_Aktywne = false;

        private void toolStripTextBox1_Enter(object sender, EventArgs e)
        {
            if (!szukanie_Aktywne)
            {
                szukanie_Aktywne = true;
                toolStripTextBox1.Text = "";
                toolStripTextBox1.ForeColor = SystemColors.WindowText;
                toolStripTextBox1.Text = "";
                toolStripTextBox1.ForeColor = SystemColors.WindowText;                
            }
        }

        private void toolStripTextBox1_TextChanged(object sender, EventArgs e)
        {
            ZaznaczPasująceWęzły();            
        }

        private void ZaznaczPasująceWęzły()
        {
            if (treeView1.Nodes.Count == 0) return;
            else CzyśćTłaPodwęzłów(treeView1.Nodes[0]);
            TreeNode[] węzły = model.SzukajElementu(toolStripTextBox1.Text);
            if (węzły != null && węzły.Length > 0)
            {
                szukanie_pasująceWęzły = węzły;
                ZaznaczPasującyWęzeł(0);
                foreach (TreeNode węzeł in szukanie_pasująceWęzły)
                {
                    węzeł.BackColor = Color.LightGray;
                }
            }
        }

        private void ZaznaczPasującyWęzeł(int indeksWęzła = -1)
        {
            if (indeksWęzła < 0) szukanie_zaznaczonyWęzeł++;
            else szukanie_zaznaczonyWęzeł = indeksWęzła;
            if (szukanie_zaznaczonyWęzeł >= szukanie_pasująceWęzły.Length) szukanie_zaznaczonyWęzeł = 0;
            treeView1.SelectedNode = szukanie_pasująceWęzły[szukanie_zaznaczonyWęzeł];
            treeView1.SelectedNode.EnsureVisible();
        }

        private static void CzyśćTłaPodwęzłów(TreeNode węzeł)
        {
            węzeł.BackColor = Color.Transparent;
            foreach (TreeNode podwęzeł in węzeł.Nodes)
            {
                CzyśćTłaPodwęzłów(podwęzeł);
            }
        }

        TreeNode[] szukanie_pasująceWęzły = null;
        int szukanie_zaznaczonyWęzeł = 0;

        //związane z klawiszem F3
        private void następnyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (szukanie_pasująceWęzły != null) ZaznaczPasującyWęzeł();
            treeView1.Select();
        }

        bool wprowadzoneZmiany = false;

        private void treeView1_DoubleClick(object sender, EventArgs e)
        {            
            if (treeView1.SelectedNode == null) return;
            KeyValuePair<XElement, TreeNode> edytowanyPara = model.listaIndeksów.Where(p => p.Value == treeView1.SelectedNode).First();

            using (OknoEdycjiElementuDrzewa oknoEdycjiElementuDrzewa = new OknoEdycjiElementuDrzewa(edytowanyPara.Key, edytowanyPara.Value.ForeColor == Color.Navy))
            {
                try
                {                    
                    if (oknoEdycjiElementuDrzewa.ShowDialog() == DialogResult.OK)
                    {
                        edytowanyPara.Value.Text = edytowanyPara.Key.Name.LocalName + " (" + edytowanyPara.Key.Value + ")";
                        wprowadzoneZmiany = true;
                    }
                }
                catch (Exception exc)
                {
                    MessageBox.Show(
                        "Nie powiodła się edycja węzła drzewa.\nBłąd: " + exc.Message);
                }
            }
        }

        private void pasekStanuWidocznyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            statusStrip1.Visible = pasekStanuWidocznyToolStripMenuItem.Checked;
        }

        private void pasekNarzędziToolStripMenuItem_Click(object sender, EventArgs e)
        {
            toolStrip1.Visible = pasekNarzędziToolStripMenuItem.Checked;
        }

        private void plikToolStripMenuItem_DropDownOpening(object sender, EventArgs e)
        {
            if (toolStripMenuItem2.DropDownItems.Count > 0) toolStripMenuItem2.Enabled = true;
        }

        private void edycjaToolStripMenuItem_DropDownOpening(object sender, EventArgs e)
        {
            edytujToolStripMenuItem.Enabled = (treeView1.SelectedNode != null);
        }

        private void toolStripMenuItem8_Click(object sender, EventArgs e)
        {
            MessageBox.Show("(c) Jacek Matulewski 2014\nAplikacja przygotowana w trakcie kursu .NET w IF UMK",this.Text,MessageBoxButtons.OK,MessageBoxIcon.Information);
        }

        private bool pytanieOZapisanieZmian()
        {
            if (!wprowadzoneZmiany) return false;

            DialogResult dr = MessageBox.Show(
                "Czy chcesz zapisać zmiany?",
                this.Text,
                MessageBoxButtons.YesNoCancel,
                MessageBoxIcon.Question,
                MessageBoxDefaultButton.Button3);

            switch (dr)
            {
                case DialogResult.Yes:
                    zapiszToolStripMenuItem_Click(null, null);
                    return false;
                //break;
                case DialogResult.No:
                    return false;
                //break;
                case DialogResult.Cancel:
                    return true;
                //break;
                default:
                    throw new Exception("Nie rozpoznana ewentualność");
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = pytanieOZapisanieZmian();            
        }

        private void toolStripTextBox1_Leave(object sender, EventArgs e)
        {
            if (toolStripTextBox1.Text == String.Empty)
            {
                toolStripTextBox1.Text = "Szukaj";
                toolStripTextBox1.ForeColor = SystemColors.ScrollBar;
                szukanie_Aktywne = false;
            }
        }

        ////Drag&Drop
        
        //TreeView1.AllowDrop=true;

        private void treeView1_ItemDrag(object sender, ItemDragEventArgs e)
        {
            if (e.Button == MouseButtons.Left) DoDragDrop(e.Item, DragDropEffects.Move);
            else if (e.Button == MouseButtons.Right) DoDragDrop(e.Item, DragDropEffects.Copy);
        }

        private void treeView1_DragEnter(object sender, DragEventArgs e)
        {
            e.Effect = e.AllowedEffect;
        }

        private void treeView1_DragOver(object sender, DragEventArgs e)
        {
            Point punktDocelowy = treeView1.PointToClient(new Point(e.X, e.Y));
            treeView1.SelectedNode = treeView1.GetNodeAt(punktDocelowy);
        }

        private void treeView1_DragDrop(object sender, DragEventArgs e)
        {
            Point punktDocelowy = treeView1.PointToClient(new Point(e.X, e.Y));
            TreeNode węzełDocelowy = treeView1.GetNodeAt(punktDocelowy);
            TreeNode węzełŹródłowy = (TreeNode)e.Data.GetData(typeof(TreeNode));

            if (węzełDocelowy != węzełŹródłowy)
            {
                if (jestPotomny(węzełDocelowy, węzełŹródłowy)) MessageBox.Show("Nie można przenieść węzła do jednego z jego potomków!");
                else
                {
                    if (e.Effect == DragDropEffects.Move)
                    {
                        węzełŹródłowy.Remove();
                        węzełDocelowy.Nodes.Add(węzełŹródłowy);
                    }
                    else if (e.Effect == DragDropEffects.Copy)
                    {
                        TreeNode cp = (TreeNode)węzełŹródłowy.Clone();
                        węzełDocelowy.Nodes.Add(cp);
                        cp.Expand();
                    }
                    węzełDocelowy.Expand();
                    model.TreeViewDoXml(treeView1.Nodes);
                }
            }
        }

        private bool jestPotomny(TreeNode potomek, TreeNode rodzic)
        {
            if (potomek.Parent == null) return false;
            else if (potomek.Parent == rodzic) return true;
            else return jestPotomny(potomek.Parent, rodzic);
        }
        ////Drag&Drop

        ////Kontekstowe
        private TreeNode węzełKontekst1 = null;
        private TreeNode węzełKontekst2 = null;
        private bool akcjaWytnij = false;

        private void treeView1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                TreeNode węzeł = treeView1.GetNodeAt(new Point(e.X, e.Y));
                treeView1.SelectedNode = węzeł;
                węzełKontekst1 = węzeł;
                contextMenuStrip1.Show(Control.MousePosition);
            }
        }

        private void dodajElementDrzewa(object sender, EventArgs e, TreeNode nowy)
        {
            węzełKontekst1.Nodes.Add(nowy);
            model.TreeViewDoXml(treeView1.Nodes);
            treeView1.SelectedNode = nowy;
            treeView1_DoubleClick(sender, e);
        }

        private void dodajToolStripMenuItem_Click(object sender, EventArgs e)
        {
            TreeNode nowy = new TreeNode("NowyWęzeł");
            dodajElementDrzewa(sender, e, nowy);
        }

        private void dodajZWartToolStripMenuItem_Click(object sender, EventArgs e)
        {
            TreeNode nowy = new TreeNode("NowyWęzeł ()");
            nowy.ForeColor = Color.Navy;
            dodajElementDrzewa(sender, e, nowy);
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (kopiujToolStripMenuItem.Enabled == false) return;
            if (węzełKontekst2 != null && akcjaWytnij)
            {
                odszarzGałąź(węzełKontekst2);
                akcjaWytnij = false;
            }
            węzełKontekst2 = (TreeNode)węzełKontekst1.Clone();
            wklejToolStripMenuItem.Enabled = true;
            wklejToolStripMenuItem1.Enabled = true;
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (wytnijToolStripMenuItem.Enabled == false) return;
            if (węzełKontekst2 != null) odszarzGałąź(węzełKontekst2);
            węzełKontekst2 = węzełKontekst1;
            akcjaWytnij = true;
            wklejToolStripMenuItem.Enabled = true;
            wklejToolStripMenuItem1.Enabled = true;
            wyszarzGałąź(węzełKontekst2);
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (wklejToolStripMenuItem.Enabled == false) return;
            if (akcjaWytnij)
            {
                if (jestPotomny(węzełKontekst1, węzełKontekst2)) MessageBox.Show("Nie można przenieść węzła do jednego z jego potomków!");
                else
                {
                    węzełKontekst2.Remove();
                    węzełKontekst1.Nodes.Add(węzełKontekst2);
                    odszarzGałąź(węzełKontekst2);
                    węzełKontekst2 = null;
                    wklejToolStripMenuItem.Enabled = false;
                    wklejToolStripMenuItem1.Enabled = false;
                    węzełKontekst1.ExpandAll();
                    model.TreeViewDoXml(treeView1.Nodes);
                }
            }
            else
            {
                węzełKontekst1.Nodes.Add(węzełKontekst2);
                węzełKontekst2 = (TreeNode)węzełKontekst2.Clone();
                węzełKontekst1.ExpandAll();
                model.TreeViewDoXml(treeView1.Nodes);
            }
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            węzełKontekst1.Remove();
            model.TreeViewDoXml(treeView1.Nodes);
        }

        void wyszarzGałąź(TreeNode węzeł)
        {
            węzeł.BackColor = Color.LightGray;
            foreach (TreeNode w in węzeł.Nodes) wyszarzGałąź(w);
        }

        void odszarzGałąź(TreeNode węzeł)
        {
            węzeł.BackColor = Color.White;
            foreach (TreeNode w in węzeł.Nodes) odszarzGałąź(w);
        }

        private void edytujToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            treeView1_DoubleClick(sender, e);
        }

        private void dodajToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            węzełKontekst1 = treeView1.SelectedNode;
            dodajToolStripMenuItem_Click(sender, e);
        }

        private void dodajZWartToolStripMenuItem1_DoubleClick(object sender, EventArgs e)
        {
            węzełKontekst1 = treeView1.SelectedNode;
            dodajToolStripMenuItem_Click(sender, e);
        }

        private void dodajZWartToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            węzełKontekst1 = treeView1.SelectedNode;
            dodajZWartToolStripMenuItem_Click(sender, e);
        }

        private void kopiujToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            węzełKontekst1 = treeView1.SelectedNode;
            kopiujToolStripMenuItem_Click(sender, e);
        }

        private void wytnijToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            węzełKontekst1 = treeView1.SelectedNode;
            wytnijToolStripMenuItem_Click(sender, e);
        }

        private void wklejToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            węzełKontekst1 = treeView1.SelectedNode;
            wklejToolStripMenuItem_Click(sender, e);
        }

        private void usuńToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            węzełKontekst1 = treeView1.SelectedNode;
            usuńToolStripMenuItem_Click(sender, e);
        }

        private void treeView1_AfterSelect(object sender, TreeViewEventArgs e)
        {
            if (treeView1.SelectedNode == treeView1.Nodes[0])
            {
                usuńToolStripMenuItem1.Enabled = false;
                wytnijToolStripMenuItem1.Enabled = false;
            }
            else
            {
                usuńToolStripMenuItem1.Enabled = true;
                wytnijToolStripMenuItem1.Enabled = true;
            }
            kopiujToolStripMenuItem1.Enabled = true;
            dodajToolStripMenuItem1.Enabled = true;
            dodajZWartToolStripMenuItem1.Enabled = true;
        }
        ////Kontekstowe
    }
}
