﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Printing;
using System.Xml.Linq;

namespace EdytorXML
{
    class Drukowanie
    {
        PrintDocument printDocument = new PrintDocument();
        PrintDialog printDialog = new PrintDialog();


        public Drukowanie()
        {
            printDialog.Document = printDocument;
        }

        #region Drukowanie "tekstowe"
        private string[] zawartośćPliku;
        private Font czcionka;

        public bool DrukujPlikTekstowy(string ścieżkaDoPliku, Font czcionka)
        {
            try
            {
                this.czcionka = czcionka;

                DialogResult dr = printDialog.ShowDialog();
                if (dr == DialogResult.OK)
                {
                    zawartośćPliku = CzytajPlikTekstowy(ścieżkaDoPliku);
                    printDocument.PrintPage += printDocument_PrintPage_Tekst;
                    printDocument.DocumentName = "EdytorXML - " + ścieżkaDoPliku;
                    Task.Run((Action)printDocument.Print);
                }
                return true;
            }
            catch
            {
                MessageBox.Show("Błąd podczas drukowania", "EdytorXML", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }
        }

        private static string[] CzytajPlikTekstowy(string nazwaPliku)
        {
            List<string> tekst = new List<string>();
            try
            {
                using (StreamReader sr = new StreamReader(nazwaPliku))
                {
                    string wiersz;
                    while ((wiersz = sr.ReadLine()) != null)
                    {
                        tekst.Add(wiersz);
                    }
                };
                return tekst.ToArray();
            }
            catch
            {
                throw;
            }
        }

        private StringReader sr = null;

        private void printDocument_PrintPage_Tekst(object sender, PrintPageEventArgs e)
        {
            int wysokośćWiersza = (int)czcionka.GetHeight(e.Graphics);
            int ilośćLinii = e.MarginBounds.Height / wysokośćWiersza;

            if (sr == null)
            {
                string tekst = "";
                foreach (string wiersz in zawartośćPliku)
                {
                    float szerokość = e.Graphics.MeasureString(wiersz, czcionka).Width;
                    if (szerokość < e.MarginBounds.Width)
                    {
                        tekst += wiersz + "\n";
                    }
                    else
                    {
                        float średniaSzerokośćLitery = szerokość / wiersz.Length;
                        int ileLiterWWierszuDrukowanym = (int)(e.MarginBounds.Width / średniaSzerokośćLitery) - 4;
                        string skracanyWiersz = wiersz;
                        do
                        {
                            tekst += skracanyWiersz.Substring(0, ileLiterWWierszuDrukowanym) + "[CR]\n";
                            skracanyWiersz = skracanyWiersz.Substring(ileLiterWWierszuDrukowanym).Trim(' ');

                        }
                        while (skracanyWiersz.Length > ileLiterWWierszuDrukowanym);
                        tekst += skracanyWiersz + "\n";
                    }
                }
                sr = new StringReader(tekst);
            }

            e.HasMorePages = true;

            for (int i = 0; i < ilośćLinii; ++i)
            {
                string wiersz = sr.ReadLine();
                if (wiersz == null)
                {
                    e.HasMorePages = false;
                    sr = null;
                    break;
                }
                e.Graphics.DrawString(
                    wiersz,
                    czcionka,
                    Brushes.Black, //kolor, pędzel
                    e.MarginBounds.Left, //x
                    e.MarginBounds.Top + i * wysokośćWiersza); //y
            }
        }
        #endregion

        #region Drukowanie graficzne
        private Model model;
        private int lewyMargines = 0;
        private int wysokośćWiersza;
        private int pozycjaKursora=0;
        private void Szukaj(IEnumerable<XElement> xelement, int odstep, PrintPageEventArgs e)
        {
            foreach (var element in xelement)
            {
                if (element.HasElements) // gdy mamy podelementy
                {
                    //rysowanie linii poziomej
                    e.Graphics.DrawLine(new Pen(Color.Black),
                        new Point(e.MarginBounds.Left + odstep * 15, e.MarginBounds.Top + pozycjaKursora * wysokośćWiersza),
                        new Point(e.MarginBounds.Width, e.MarginBounds.Top + pozycjaKursora * wysokośćWiersza)
                        );

                    //wstawienie nagłówka
                    e.Graphics.DrawString(
                        element.Name.ToString() + ":",
                        czcionka,
                        Brushes.Black, //kolor, pędzel
                        e.MarginBounds.Left + odstep * 15, //x
                        e.MarginBounds.Top + pozycjaKursora * wysokośćWiersza);

                    pozycjaKursora++;
                    Szukaj(element.Elements(), odstep + 1, e); // szukanie podwezlow
                }
                else // gdy już nie ma podelementów
                {
                    //linia pionowa
                    e.Graphics.DrawLine(new Pen(Color.LightBlue, 3),
                        new Point(e.MarginBounds.Left + odstep * 15, e.MarginBounds.Top + pozycjaKursora * wysokośćWiersza),
                        new Point(e.MarginBounds.Left + odstep * 15, e.MarginBounds.Top + pozycjaKursora * wysokośćWiersza + wysokośćWiersza)
                        );

                    //wartość
                    e.Graphics.DrawString(
                        element.Name.ToString() + ": " + element.Value.ToString(),
                        czcionka,
                        Brushes.Black, //kolor, pędzel
                        e.MarginBounds.Left + odstep * 15, //x
                        e.MarginBounds.Top + pozycjaKursora * wysokośćWiersza);
                    pozycjaKursora++;
                }

            }
            if (odstep == 0) e.HasMorePages = false; // gdy wykonanie pierwszej petli się skończy. Można by to też dać w printDocument_PrintPage_Grafika
            
            

        }
        public bool DrukujDrzewoGraficznie(Model model, Font czcionka, int grubośćLinii)
        {
            try
            {
                this.czcionka = czcionka;
                this.model = model;
                

                DialogResult dr = printDialog.ShowDialog();
                if (dr == DialogResult.OK)
                {
                    printDocument.PrintPage += printDocument_PrintPage_Grafika;
                    printDocument.DocumentName = "EdytorXML - " + model.ŚcieżkaDoPliku + " (drzewo)";
                    Task.Run((Action)printDocument.Print);
                }
                return true;
            }
            catch
            {
                MessageBox.Show("Błąd podczas drukowania", "EdytorXML", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }
        }

        private void printDocument_PrintPage_Grafika(object sender, PrintPageEventArgs e)
        {
            wysokośćWiersza = (int)czcionka.GetHeight(e.Graphics);
            e.HasMorePages = true;
            Szukaj(model.listaIndeksów.Keys.ElementAt(0).Elements(), lewyMargines, e); // bo w zerowym elemencie jest wszystko

        #endregion
        }
    }
}
