﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LINQtoObjects_2014
{
    class Osoba
    {
        public string Imię;
        public string Nazwisko;
        public string Telefon;
        public int Wiek;

        public override string ToString()
        {
            return this.Imię + " " + this.Nazwisko + " (" + this.Wiek + "), tel. " + this.Telefon;
        }

        //*
        public Osoba()
        {
        }
        //*/
          
        public Osoba(Osoba wzór)
        {
            this.Imię = wzór.Imię;
            this.Nazwisko=wzór.Nazwisko;
            this.Telefon=wzór.Telefon;
            this.Wiek =wzór.Wiek;
        }
    };

    class Program
    {
        static void Main_LINQ()
        {
            Osoba[] studenci = new Osoba[]
            {
                new Osoba(){Imię = "Jacek", Nazwisko="Matulewski", Telefon="000000000", Wiek=42},
                new Osoba(){Imię="Alina", Nazwisko="Suchomska", Telefon="1111111111", Wiek=18},
                new Osoba(){Imię="Marek", Nazwisko="Orliński", Telefon="2222222222", Wiek=21},
                new Osoba(){Imię="Jakub", Nazwisko="Majewski", Telefon="3333333333", Wiek=20},
                new Osoba(){Imię="Karolina", Nazwisko="Matulewski", Telefon="44444444444", Wiek=13},
                new Osoba(){Imię="Mateusz", Nazwisko="Sionkowski", Telefon="55555555555", Wiek=23}
            };

            Console.WriteLine("Wszyscy studenci:");
            foreach (Osoba osoba in studenci)
                Console.WriteLine(osoba.ToString());

            var studentki = from Osoba osoba in studenci
                            where osoba.Imię.EndsWith("a")
                            orderby osoba.Nazwisko, osoba.Imię, osoba.Wiek descending
                            select osoba.Imię + " " + osoba.Nazwisko + "(" + osoba.Wiek + ")";

            Console.WriteLine("\nStuentki:");
            foreach (string personalia in studentki)
                Console.WriteLine(personalia);

            var studenciStarsi23 = (
                from Osoba osoba in studenci
                where !osoba.Imię.EndsWith("a") && osoba.Wiek >= 22
                select osoba
                //select new Osoba(osoba)
            ).ToArray();

            Console.WriteLine("\nStudenci 23+:");
            foreach (Osoba osoba in studenciStarsi23)
                Console.WriteLine(osoba);

            //studenciStarsi23.ElementAt(1).Wiek++;
            studenciStarsi23[1].Wiek++;

            Console.WriteLine("\nStudenci 23+, po zmianie:");
            foreach (Osoba osoba in studenciStarsi23)
                Console.WriteLine(osoba);

            Console.WriteLine("\nWszyscy studenci, po zmianie:");
            foreach (Osoba osoba in studenci)
                Console.WriteLine(osoba.ToString());

            var studenciMaNazwisko5 = from osoba in studenci
                                      where osoba.Imię.StartsWith("Ma") && osoba.Nazwisko.Length > 9
                                      select osoba.ToString();

            Console.WriteLine("\nStudenci z imieniem na \"Ma\", nazwisko dłuższe niż 5:");
            foreach (string personalia in studenciMaNazwisko5)
                Console.WriteLine(personalia);

            Console.WriteLine("Naciśnij ENTER...");
            Console.ReadLine();
        }

        static void Main_ClassVsStruct()
        {
            Osoba osoba1 = new Osoba() { Wiek = 1 };
            Osoba osoba2 = osoba1;
            osoba2.Wiek = 2;
            Console.WriteLine("\n\no1: " + osoba1.Wiek.ToString() + ", o2: " + osoba2.Wiek.ToString());

            Console.WriteLine("Naciśnij ENTER...");
            Console.ReadLine();
        }

        static void Main(string[] args)
        {
            Main_LINQ();
            Main_ClassVsStruct();
        }
    }
}
