﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Xml.Linq;
using TreeNode = System.Windows.Forms.TreeNode;
using TreeNodeCollection = System.Windows.Forms.TreeNodeCollection;
using Color = System.Drawing.Color;
using System.IO;

namespace EdytorXML
{
    class Model
    {
        private string ścieżkaDoPliku = null;
        private bool czyLokalnyPlik = false;
        private bool czyZmieniony = false;
        private XDocument xml = null;

        public Dictionary<XElement, TreeNode> listaIndeksów = new Dictionary<XElement,TreeNode>();

        public string ŚcieżkaDoPliku
        {
            get
            {
                return ścieżkaDoPliku;
            }
        }
        public bool CzyLokalnyPlik
        {
            get
            {
                return czyLokalnyPlik;
            }
        }
        public bool CzyZmieniony
        {
            get
            {
                return czyZmieniony;
            }
        }
        public int Count
        {
            get
            {
                return listaIndeksów.Count;
            }
        }
        

        public void CzytajDaneZPlikuXml(string ścieżkaDoPlikuXml)
        {
            xml = XDocument.Load(ścieżkaDoPlikuXml);
            ścieżkaDoPliku = ścieżkaDoPlikuXml;
            czyLokalnyPlik = true;
            czyZmieniony = false;
        }

        public void CzytajDaneZUrl(string adresSieciowyPliku)
        {
            xml = XDocument.Load(adresSieciowyPliku);
            ścieżkaDoPliku = null;
            czyLokalnyPlik = false;
            czyZmieniony = false;
        }

        public void ZapiszDaneDoPliku(string ścieżkaDoPlikuXml)
        {
            xml.Save(ścieżkaDoPlikuXml);
            ścieżkaDoPliku = ścieżkaDoPlikuXml;
            czyLokalnyPlik = true;
            czyZmieniony = false;
        }

        private static TreeNode TwórzWęzełDrzewaZElementuXml(XElement element, Dictionary<XElement, TreeNode> listaIndeksów = null)
        {
            TreeNode węzeł = new TreeNode(element.Name.LocalName);
            if (listaIndeksów != null) listaIndeksów.Add(element, węzeł);
            foreach (XElement podelement in element.Elements())
            {
                if (element.HasElements) węzeł.Nodes.Add(TwórzWęzełDrzewaZElementuXml(podelement, listaIndeksów));
            }
            if (!element.HasElements && element.Value != null)
            {
                węzeł.Text += " (" + element.Value + ")";
                węzeł.ForeColor = Color.Navy;
            }            
            return węzeł;
        }

        public void TwórzDrzewoNaPodstawieModelu(TreeNodeCollection nodes)
        {
            TreeNode węzełGłówny = new TreeNode(xml.Root.Name.LocalName);            
            nodes.Clear();
            nodes.Add(Model.TwórzWęzełDrzewaZElementuXml(xml.Root, listaIndeksów));            
        }

        public TreeNode[] SzukajElementu(string szukanaFraza)
        {
            IEnumerable<TreeNode> pasująceWęzły = from KeyValuePair<XElement, TreeNode> indeks in listaIndeksów
                                                  where indeks.Key.Name.LocalName.Contains(szukanaFraza) // || indeks.Key.Value.Contains(szukanaFraza)
                                                  select indeks.Value;
         
            //string s = "Lista pasujących węzłów:\n";
            //foreach (TreeNode węzeł in pasująceWęzły) s += "["+węzeł.Text + "]\n";
            //System.Windows.Forms.MessageBox.Show(s);

            return pasująceWęzły.ToArray();
        }
    }
}
