﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Xml.Linq;

namespace EdytorXML
{
    public partial class Form1 : Form
    {
        private Model model = new Model();

        public Form1()
        {
            InitializeComponent();

            //odtwarzać edytowany ostatnio plik (ustawienia aplikacji)
        }

        public void OdświeżWidokDrzewa()
        {
            treeView1.BeginUpdate();
            model.TwórzDrzewoNaPodstawieModelu(treeView1.Nodes);
            treeView1.EndUpdate();
            treeView1.ExpandAll();
            treeView1.Nodes[0].EnsureVisible();            
        }

        private void czytajPlikToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (model.CzyLokalnyPlik) openFileDialog1.FileName = model.ŚcieżkaDoPliku;
            DialogResult dr = openFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                Cursor = Cursors.WaitCursor;
                try
                {
                    model.CzytajDaneZPlikuXml(openFileDialog1.FileName);
                    nazwaPlikuToolStripStatusLabel.Text = System.IO.Path.GetFileName(model.ŚcieżkaDoPliku) + " (" + model.Count + ")";
                    OdświeżWidokDrzewa();
                }
                catch (Exception exc)
                {
                    MessageBox.Show(
                        "Nie powiodło się odczytanie pliku XML \"" + openFileDialog1.FileName + "\"\nBłąd: " + exc.Message,
                        this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                finally
                {
                    Cursor = Cursors.Default;
                }
            }
        }

        private void otworzAdresURLToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (var oknoEdycjiURL = new OknoEdycjiURL())
            {
                try
                {
                    if (oknoEdycjiURL.URL == null || oknoEdycjiURL.URL == "") oknoEdycjiURL.URL = "http://www.nbp.pl/kursy/xml/LastA.xml";
                    if (oknoEdycjiURL.ShowDialog() == DialogResult.OK)
                    {
                        Cursor = Cursors.WaitCursor;
                        model.CzytajDaneZUrl(oknoEdycjiURL.URL);
                        nazwaPlikuToolStripStatusLabel.Text = oknoEdycjiURL.URL;
                        OdświeżWidokDrzewa();
                    }
                }
                catch (Exception exc)
                {
                    MessageBox.Show(
                        "Nie powiodło się odczytanie pliku XML z adresu \"" + openFileDialog1.FileName + "\"\nBłąd: " + exc.Message,
                        this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                finally
                {
                    Cursor = Cursors.Default;                    
                }
            }
        }

        private void zapiszDoPlikuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (model.CzyLokalnyPlik) saveFileDialog1.FileName = model.ŚcieżkaDoPliku;
            DialogResult dr = saveFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                try
                {
                    model.ZapiszDaneDoPliku(saveFileDialog1.FileName);
                    nazwaPlikuToolStripStatusLabel.Text = model.ŚcieżkaDoPliku + " (" + model.Count + ")";                    
                }
                catch (Exception exc)
                {
                    MessageBox.Show(
                        "Nie powiodło się zapisanie pliku XML \"" + saveFileDialog1.FileName + "\"\nBłąd: " + exc.Message,
                        this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        private void toolStripMenuItem4_Click(object sender, EventArgs e)
        {
            treeView1.CollapseAll();
        }

        private void rozwińWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            treeView1.ExpandAll();
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = treeView1.BackColor;
            DialogResult dr = colorDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                treeView1.BackColor = colorDialog1.Color;
            }
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = treeView1.Font;
            fontDialog1.Color = treeView1.ForeColor;
            DialogResult dr = fontDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                treeView1.Font = fontDialog1.Font;
                treeView1.ForeColor = fontDialog1.Color;
            }
        }

        private static void CzyśćTłaWęzłów(TreeNode węzeł)
        {
            węzeł.BackColor = Color.Transparent;
            foreach (TreeNode podwęzeł in węzeł.Nodes)
            {
                CzyśćTłaWęzłów(podwęzeł);
            }
        }        

        int szukanie_zaznaczonyWęzeł = 0;
        private TreeNode[] szukanie_pasująceWęzły;

        private void ZaznaczPasująceWęzły()
        {
            foreach (TreeNode pasującyWęzeł in szukanie_pasująceWęzły) pasującyWęzeł.BackColor = Color.LightGray;
            TreeNode zaznaczonyWęzeł = szukanie_pasująceWęzły[szukanie_zaznaczonyWęzeł];
            //zaznaczonyWęzeł.BackColor = Color.Gray;
            zaznaczonyWęzeł.EnsureVisible();
            treeView1.SelectedNode = zaznaczonyWęzeł; //HideSelection = false
        }

        private void toolStripTextBox1_TextChanged(object sender, EventArgs e)
        {
            if (model.Count == 0) return;
            if (toolStripTextBox1.Text.Length > 0)
            {
                szukanie_pasująceWęzły = model.SzukajElementu(toolStripTextBox1.Text);
                this.Text = szukanie_pasująceWęzły.Count().ToString();
                if (szukanie_pasująceWęzły.Count() > 0)
                {                    
                    CzyśćTłaWęzłów(treeView1.Nodes[0]);
                    ZaznaczPasująceWęzły();        
                }
            }                        
        }

        private void toolStripTextBox1_Enter(object sender, EventArgs e)
        {
            if (toolStripTextBox1.ForeColor == SystemColors.ScrollBar)
            {
                toolStripTextBox1.ForeColor = SystemColors.WindowText;
                toolStripTextBox1.Text = "";
            }
        }

        //związane z klawiszem F3
        private void następnyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (szukanie_pasująceWęzły==null || szukanie_pasująceWęzły.Count() == 0) return;
            szukanie_zaznaczonyWęzeł++;
            if (szukanie_zaznaczonyWęzeł >= szukanie_pasująceWęzły.Count()) szukanie_zaznaczonyWęzeł = 0;
            ZaznaczPasująceWęzły();
        }
    }
}
