﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Xml.Linq;
using TreeNode = System.Windows.Forms.TreeNode;
using TreeNodeCollection = System.Windows.Forms.TreeNodeCollection;
using Color = System.Drawing.Color;
using System.IO;

namespace EdytorXML
{
    class Model
    {
        private string ścieżkaDoPliku = null;
        private bool czyLokalnyPlik = false;
        private bool czyZmieniony = false;
        private XDocument xml = null;

        public string ŚcieżkaDoPliku
        {
            get
            {
                return ścieżkaDoPliku;
            }
        }
        public bool CzyLokalnyPlik
        {
            get
            {
                return czyLokalnyPlik;
            }
        }
        public bool CzyZmieniony
        {
            get
            {
                return czyZmieniony;
            }
        }

        public void CzytajDaneZPlikuXml(string ścieżkaDoPlikuXml)
        {
            xml = XDocument.Load(ścieżkaDoPlikuXml);
            ścieżkaDoPliku = ścieżkaDoPlikuXml;
            czyLokalnyPlik = true;
            czyZmieniony = false;
        }

        public void CzytajDaneZUrl(string adresSieciowyPliku)
        {
            xml = XDocument.Load(adresSieciowyPliku);
            ścieżkaDoPliku = null;
            czyLokalnyPlik = false;
            czyZmieniony = false;
        }

        public void ZapiszDaneDoPliku(string ścieżkaDoPlikuXml)
        {
            xml.Save(ścieżkaDoPlikuXml);
            ścieżkaDoPliku = ścieżkaDoPlikuXml;
            czyLokalnyPlik = true;
            czyZmieniony = false;
        }

        private static TreeNode TwórzWęzełDrzewaZElementuXml(XElement element)
        {
            TreeNode węzeł = new TreeNode(element.Name.LocalName);
            foreach (XElement podelement in element.Elements())
            {
                if (element.HasElements) węzeł.Nodes.Add(TwórzWęzełDrzewaZElementuXml(podelement));
            }
            if (!element.HasElements && element.Value != null)
            {
                węzeł.Text += " (" + element.Value + ")";
                węzeł.ForeColor = Color.Navy;
            }            
            return węzeł;
        }

        public void TwórzDrzewoNaPodstawieModelu(TreeNodeCollection nodes)
        {
            TreeNode węzełGłówny = new TreeNode(xml.Root.Name.LocalName);            
            nodes.Clear();
            nodes.Add(Model.TwórzWęzełDrzewaZElementuXml(xml.Root));            
        }
    }
}
