﻿using System;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;

using System.Media;
using Microsoft.Win32;
using Choinka.Properties;
using System.Runtime.InteropServices;
using System.Text;
using System.Collections.Generic;

namespace Choinka
{
    public partial class Form1 : Form
    {
        SoundPlayer sp = null;
        Settings ustawienia = new Settings();

        public Form1()
        {
            InitializeComponent();

            string katalog = Application.StartupPath;
            sp = new SoundPlayer(System.IO.Path.Combine(katalog, "Choinka.wav"));
            this.Size = pictureBox1.Image.Size;
            ukryjToolStripMenuItem.Tag = false;
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Escape) Close();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            notifyIcon1.Visible = false;
            ustawienia.dzwiek = toolStripMenuItem2.Checked;
            ustawienia.Save();

            zanik();
        }

        private void zanik()
        {
            for (; Opacity > 0; Opacity -= 0.01)
                System.Threading.Thread.Sleep(5);
        }

        private void powrot()
        {
            for (; Opacity < 1; Opacity += 0.01)
                System.Threading.Thread.Sleep(5);
        }

        private void zamknijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void zawszeNaWierzchuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.TopMost = zawszeNaWierzchuToolStripMenuItem.Checked;
        }

        private void ukryjToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!(bool)ukryjToolStripMenuItem.Tag)
            {
                this.Hide();
                ukryjToolStripMenuItem.Text = "Pokaż";
                ukryjToolStripMenuItem.Tag = true;
            }
            else
            {
                this.Show();
                ukryjToolStripMenuItem.Text = "Ukryj";
                ukryjToolStripMenuItem.Tag = false;
            }
        }

        private void oAutorzeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show("Kurs .NET 2013/2014");
        }

        private void stronaUMKToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Process.Start("http://www.umk.pl");
        }

        private void notifyIcon1_DoubleClick(object sender, EventArgs e)
        {
            notifyIcon1.BalloonTipTitle = "Gwiazdka " + DateTime.Now.Year;
            notifyIcon1.BalloonTipText = "Wszystkiego najlepszego od studentów kursu .NET";
            notifyIcon1.BalloonTipText += "\n" + notifyIcon1.Text;
            notifyIcon1.ShowBalloonTip(2000);
        }

        private void notifyIcon1_MouseMove(object sender, MouseEventArgs e)
        {
            notifyIcon1.Text = "Do gwiazdki pozostało jeszcze " + (24 - DateTime.Now.Day).ToString() + " dni!";
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            if (toolStripMenuItem2.Checked) sp.PlayLooping();
            else sp.Stop();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            toolStripMenuItem2.Checked = ustawienia.dzwiek; toolStripMenuItem2_Click(null, null);
            if (toolStripMenuItem2.Checked) sp.PlayLooping();
            teleport();
            kier();
        }

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            try
            {
                RegistryKey kluczRejestruRun = Registry.CurrentUser.OpenSubKey(@"Software\Microsoft\Windows\CurrentVersion\Run", true);
                if (kluczRejestruRun.GetValueNames().Contains("Choinka")) kluczRejestruRun.DeleteValue("Choinka");
                kluczRejestruRun.SetValue("Choinka", "\"" + Application.ExecutablePath + "\"");
                kluczRejestruRun.Close();
                MessageBox.Show("Dodano zapis w rejestrze");
            }
            catch (Exception exc)
            {
                MessageBox.Show("Dodanie zapisu w rejestrze nie powiodło się.\nBłąd: " + exc.Message, "Choinka", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void pictureBox1_Paint(object sender, PaintEventArgs e)
        {
            biegnij();
        }
    }
}
