﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace ChodzacyMikolaj
{
    public partial class Mikolaj : Form
    {
        private Bitmap[] _picture = null;
        private int _deskopeHeight = Screen.PrimaryScreen.Bounds.Height; // wysokosc ekranu
        private int _deskopeWidth = Screen.PrimaryScreen.Bounds.Width; // szerokosc ekranu
        private int _amOfPictures = 6; // Ilosc obrazkow
        private int _nrOfPicture = 0; // Obrazek poczatkowy
        private int _nrOfSide = 1; // Kierunek
        private int _moveStep = 7;
        private bool _leftRight = true;
        private Point? _StartPoint = null;

        public Mikolaj()
        {
            InitializeComponent();

            _picture = new Bitmap[_amOfPictures];
            string adress = Application.StartupPath;

            for (int i = 1; i <= _amOfPictures; ++i)
                _picture[i - 1] = new Bitmap(System.IO.Path.Combine(adress, i.ToString() + ".png"));

            this.Height = _picture[_nrOfPicture].Height;
            this.Width = _picture[_nrOfPicture].Width;

            this.TransparencyKey = _picture[_nrOfPicture].GetPixel(0, 0);
            this.BackColor = Color.FromArgb(255, 236, 46, 180);
            this.TopMost = true;
        }

        private void Mikolaj_Paint(object sender, PaintEventArgs e)
        {
            e.Graphics.DrawImage(_picture[_nrOfPicture], 0, 0, _picture[_nrOfPicture].Width, _picture[_nrOfPicture].Height);
        }

        private void RePaint()
        {
            _nrOfPicture++;
            if (_nrOfPicture >= _nrOfSide * 3)
                _nrOfPicture -= 3;
            using (Graphics bufferGrph = Graphics.FromImage(_picture[_nrOfPicture]))
            {
                bufferGrph.DrawImage(_picture[_nrOfPicture], 0, 0, _picture[_nrOfPicture].Width, _picture[_nrOfPicture].Height);
            }
            this.Invalidate();
        }

        private void Mikolaj_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                _StartPoint = new Point(e.X, e.Y);
                timer.Stop();
            }
        }

        private void Mikolaj_MouseMove(object sender, MouseEventArgs e)
        {
            if (_StartPoint.HasValue)
            {
                this.Left += e.X - _StartPoint.Value.X;
                this.Top += e.Y - _StartPoint.Value.Y;
            }
        }

        private void Mikolaj_MouseUp(object sender, MouseEventArgs e)
        {
            _StartPoint = null;
            timer.Start();
        }

        private void Mikolaj_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Escape)
            {
                timer.Stop();
                Close();
            }
        }

        private void Mikolaj_Load(object sender, EventArgs e)
        {
            this.Left = 0;
            this.Top = this._deskopeHeight - this.Height - 40;
            timer.Start();
        }

        private void timer_Tick(object sender, EventArgs e)
        {
            if (_leftRight)
            {
                if ((this._deskopeWidth - _picture[_nrOfPicture].Width) < this.Left)
                {
                    _leftRight = false;
                    _nrOfSide = 2;
                    _nrOfPicture = 3;
                }
                this.Left += _moveStep;
            }
            else
            {
                if (0 > this.Left)
                {
                    _leftRight = true;
                    _nrOfSide = 1;
                    _nrOfPicture = 0;
                }
                this.Left -= _moveStep;
            }
            this.RePaint();
        }
    }
}
