﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using ProgramistaMag;

namespace UlamekTesty
{
    [TestClass]
    public class UlamekTesty
    {
        [TestMethod]
        public void TestKonstruktoraIWłasności()
        {
            //przygotowanie
            int licznik = 4;
            int mianownik = 2;            

            //dzialanie
            Ulamek u = new Ulamek(licznik, mianownik);

            //weryfikacja
            Assert.AreEqual(licznik, u.Licznik, "Niezgodność w liczniku");
            Assert.AreEqual(mianownik, u.Mianownik, "Niezgodność w mianowniku");            
        }

        [TestMethod]
        public void TestKonstruktora()
        {
            //przygotowanie
            int licznik = 4;
            int mianownik = 2;

            //dzialanie
            Ulamek u = new Ulamek(licznik, mianownik);

            //weryfikacja
            PrivateObject prywatnyObiekt = new PrivateObject(u);
            Assert.AreEqual(licznik, (int)prywatnyObiekt.GetField("licznik"), "Niezgodność w liczniku");
            Assert.AreEqual(mianownik, (int)prywatnyObiekt.GetField("mianownik"), "Niezgodność w mianowniku");                        
        }

        /*
        [TestMethod]
        public void TestWlasnosci()
        {
            //przygotowanie
            int licznik = 4;
            int mianownik = 2;
            Ulamek u = new Ulamek();
            PrivateObject prywatnyObiekt = new PrivateObject(u);
            prywatnyObiekt.SetField("licznik", licznik);
            prywatnyObiekt.SetField("mianownik", mianownik);            

            //dzialanie
            //int u_licznik = u.Licznik;
            //int u_mianownik = u.Mianownik;
            int u_licznik = (int)prywatnyObiekt.GetField("licznik");
            int u_mianownik = (int)prywatnyObiekt.GetField("mianownik");

            //weryfikacja            
            Assert.AreEqual(licznik, u_licznik, "Niezgodność w liczniku");
            Assert.AreEqual(mianownik, u_mianownik, "Niezgodność w mianowniku");                        
        }
        */

        [TestMethod]
        [ExpectedException(typeof(ArgumentException))]
        public void TestKonstruktoraWyjatek()
        {
            Ulamek u = new Ulamek(1, 0);
        }

        [TestMethod]
        public void TestPolowa()
        {
            Assert.AreEqual(1, Ulamek.Polowa.Licznik);
            Assert.AreEqual(2, Ulamek.Polowa.Mianownik);
        }

        [TestMethod]
        public void TestMetodyUprosc()
        {
            Ulamek u = new Ulamek(27, -6);
            Ulamek kopia = u; //klonowanie

            u.Uprosc();

            Assert.AreEqual(kopia.ToDouble(), u.ToDouble());
        }

        [TestMethod]
        public void TestOperatorow()
        {
            Ulamek a = Ulamek.Polowa;
            Ulamek b = Ulamek.Cwierc;

            double ad = a.ToDouble();
            double bd = b.ToDouble();

            Assert.AreEqual(ad + bd, (a + b).ToDouble());
            Assert.AreEqual(ad - bd, (a - b).ToDouble());
            Assert.AreEqual(ad * bd, (a * b).ToDouble());
            Assert.AreEqual(ad / bd, (a / b).ToDouble());
        }

        //----------------------------------------

        Random r = new Random();

        private int losujLiczbeCalkowita(int? maksymalnaWartoscBezwzgledna = null)
        {
            if (!maksymalnaWartoscBezwzgledna.HasValue)
                return r.Next(int.MinValue, int.MaxValue);
            else
                maksymalnaWartoscBezwzgledna = Math.Abs(maksymalnaWartoscBezwzgledna.Value);
                return r.Next(-maksymalnaWartoscBezwzgledna.Value, maksymalnaWartoscBezwzgledna.Value);
        }

        private int losujLiczbeCalkowitaRoznaOdZera(int? maksymalnaWartoscBezwzgledna = null)
        {
            int wartosc;
            do
            {
                wartosc = losujLiczbeCalkowita(maksymalnaWartoscBezwzgledna);
            }
            while (wartosc == 0);
            return wartosc;
        }

        [TestMethod]
        public void TestKonstruktoraIWłasności_Losowy()
        {
            for (int i = 0; i < 10000000; ++i)
            {
                //przygotowanie
                int licznik = losujLiczbeCalkowita();
                int mianownik = losujLiczbeCalkowitaRoznaOdZera();

                //dzialanie
                Ulamek u = new Ulamek(licznik, mianownik);

                //weryfikacja
                Assert.AreEqual(licznik, u.Licznik, "Niezgodność w liczniku");
                Assert.AreEqual(mianownik, u.Mianownik, "Niezgodność w mianowniku");
            }
        }

        [TestMethod]
        public void TestSortowania()
        {            
            Ulamek[] tablica = new Ulamek[100];
            for (int i = 0; i < tablica.Length; ++i)
            {
                tablica[i] = new Ulamek(losujLiczbeCalkowita(), losujLiczbeCalkowitaRoznaOdZera());
            }
            
            Array.Sort(tablica);

            bool tablicaJestPosortowanaRosnaca = true;
            for (int i = 0; i < tablica.Length - 1; ++i)
            {
                if (tablica[i] > tablica[i + 1]) tablicaJestPosortowanaRosnaca = false;
            }
            Assert.IsTrue(tablicaJestPosortowanaRosnaca);
        }

        [TestMethod]
        public void TestMetodyUprosc_Losowy()
        {
            Random r = new Random(this.r.Next()); //zabezpieczenie!!!!
            for (int i = 0; i < 1000; ++i)
            {
                Ulamek u = new Ulamek(losujLiczbeCalkowita(), losujLiczbeCalkowitaRoznaOdZera());
                Ulamek kopia = u; //klonowanie

                u.Uprosc();

                Assert.IsTrue(u.Mianownik > 0);
                Assert.AreEqual(kopia.ToDouble(), u.ToDouble());
            }
        }
    }
}
