﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AsyncAwait
{
    class Program
    {
        static void MetodaZajmującaDużoCzasuProcesora(double argument = 1.0)
        {
            double wynik;
            for (int i = 0; i < 10000000; ++i)
            {
                wynik = Math.Sin(Math.Asin(Math.Sin(Math.Asin(Math.Sin(argument)))));
            }
        }


        static void Main_Parallel(string[] args)
        {
            const int liczbaIteracji = 100;

            Random r = new Random();

            //przygotowania danych            
            double[] argumenty = new double[liczbaIteracji];
            for (int i = 0; i < liczbaIteracji; ++i) argumenty[i] = 20 * r.NextDouble() - 10;

            /* Pętle */
            //obliczenia sekwencyjne
            int czasStartu = Environment.TickCount;
            //for (int i = 0; i < liczbaIteracji; ++i) MetodaZajmującaDużoCzasuProcesora(argumenty[i]);
            int czasZakończenia = Environment.TickCount;
            int czasObliczeńSekwencyjnych = czasZakończenia - czasStartu;
            Console.WriteLine("Obliczenia sekwencyjne trwały {0}", czasObliczeńSekwencyjnych);

            //obliczenia równoległe
            czasStartu = Environment.TickCount;
            Action<int> akcja = (int indeks) => 
                {
                    Console.WriteLine("Indeks iteracji: {0}", indeks);
                    MetodaZajmującaDużoCzasuProcesora(argumenty[indeks]); 
                };
            //Parallel.For(0, liczbaIteracji, akcja);
            ParallelOptions po = new ParallelOptions();
            po.MaxDegreeOfParallelism = Environment.ProcessorCount - 1;            
            Parallel.For(0, liczbaIteracji, po, akcja);
            czasZakończenia = Environment.TickCount;
            int czasObliczeńRównoległe = czasZakończenia - czasStartu;
            Console.WriteLine("Obliczenia równoległe trwały {0}", czasObliczeńRównoległe);

            Console.WriteLine("Ile rdzeni CPU: {0}", Environment.ProcessorCount);
            Console.WriteLine("Przyspieszenie: {0}", 1.0 * czasObliczeńSekwencyjnych / czasObliczeńRównoległe);

            /* Uruchamianie równoległe akcji */
            Action[] akcje = new Action[liczbaIteracji];
            for (int i = 0; i < liczbaIteracji; ++i) akcje[i] = () => { MetodaZajmującaDużoCzasuProcesora(0); };
            Parallel.Invoke(akcje);
        }

        //--------------------------------------------------------

        static void Main_Synchronicznie_Zadanie(string[] args)
        {
            //czynność
            Func<object, long> akcja =
                (object argument) =>
                {
                    Console.WriteLine("Początek działania akcji - " + argument.ToString());
                    System.Threading.Thread.Sleep(5000);
                    Console.WriteLine("Koniec działania akcji - " + argument.ToString());
                    return DateTime.Now.Ticks;
                };

            long wynik = akcja("synchronicznie");
            Console.WriteLine("Synchronicznie: " + wynik.ToString());

            //w osobnym zadaniu
            Task<long> zadanie = new Task<long>(akcja, "zadania");
            zadanie.Start();
            Console.WriteLine("Akcja została uruchomiona");
            wynik = zadanie.Result; //synchronizacja
            Console.WriteLine("Zadanie: " + wynik.ToString());
        }

        //--------------------------------------------------------

        static Task<long> UruchomAsync(object argument)
        {
            //czynność
            Func<object, long> akcja =
                (object _argument) =>
                {
                    Console.WriteLine("Początek działania akcji - " + _argument.ToString());
                    System.Threading.Thread.Sleep(5000);
                    Console.WriteLine("Koniec działania akcji - " + _argument.ToString());
                    return DateTime.Now.Ticks;
                };

            //w osobnym zadaniu
            Task<long> zadanie = new Task<long>(akcja, argument);
            zadanie.Start();
            return zadanie;
        }

        static void MetodaGlowna_Result()
        {
            Console.WriteLine("Przed uruchomieniem akcji");
            Task<long> zadanie = UruchomAsync("UruchomAsync");
            Console.WriteLine("Po uruchomieniu akcji");
            long wynik = zadanie.Result; //synchronizacja
            Console.WriteLine("UruchomAsync: " + wynik.ToString());
        }

        static async void MetodaGlowna_Await()
        {
            Console.WriteLine("Przed uruchomieniem akcji");
            Task<long> zadanie = UruchomAsync("UruchomAsync");
            Console.WriteLine("Po uruchomieniu akcji");
            long wynik = await zadanie; //synchronizacja
            Console.WriteLine("UruchomAsync: " + wynik.ToString());
        }

        static void Main(string[] args)
        {
            Console.WriteLine("Main - początek");
            //MetodaGlowna_Result();
            MetodaGlowna_Await();
            Console.WriteLine("Main - ciąg dalszy");
            Console.Write("Naciśnij Enter..."); Console.ReadLine();
            Console.WriteLine("Main - koniec");
        }
    }
}
